/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.AnypointMqMessageBuilder;
import com.mulesoft.mq.restclient.api.DestinationLocation;
import com.mulesoft.mq.restclient.api.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.internal.DefaultAnypointMqMessage;
import com.mulesoft.mq.restclient.internal.LockId;
import com.mulesoft.mq.restclient.internal.MockCourierServer;
import com.mulesoft.mq.restclient.internal.NewTtl;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;

public abstract class AbstractCourierRestClientTestCase {
    public int httpPort = new Random().nextInt(30000) + 10000;
    protected MockCourierServer server;
    protected OAuthCredentials oAuthCredential;
    protected AbstractCourierRestClient client;
    private DestinationLocation mockDestinationLocation = new DestinationLocationBuilder().setOrganizationId("no-org").setEnvironmentId("no-env").setName("some-destination").build();

    public void setup(int expectedRequests) throws Exception {
        this.setup(expectedRequests, MockCourierServer.OAUTH_CREDENTIALS);
    }

    public void setup(int expectedRequests, OAuthCredentials oAuthCredential) throws Exception {
        this.oAuthCredential = oAuthCredential;
        this.server = new MockCourierServer(this.httpPort, expectedRequests);
        this.createClient();
    }

    protected String apiUrl() {
        return "http://localhost:" + this.httpPort + "/api";
    }

    protected abstract void createClient() throws Exception;

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            MockCourierServer serverCopy = this.server;
            this.server = null;
            serverCopy.stop();
        }
        if (this.client != null) {
            this.client.dispose();
        }
    }

    @Test
    public void credentialsOk() throws Exception {
        this.setup(1);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    @Test(expected=RuntimeException.class)
    public void wrongCredentials() throws Exception {
        this.setup(1, new OAuthCredentials("client-id", "wrong-client-secret"));
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        observableOfMessages.toBlocking().first();
    }

    @Test
    public void send() throws Exception {
        this.setup(2);
        AnypointMqMessageBuilder messageBuilder = new AnypointMqMessageBuilder();
        messageBuilder.withMessageId("someMessageId");
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody("Some body");
        messageBuilder.addHeader("Some Header", "Some Header value");
        messageBuilder.addProperty("Some Property", "Some Property value");
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messageBuilder.build());
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
    }

    @Test
    public void sendBatch() throws Exception {
        this.setup(2);
        List<AnypointMqMessage> messages = Arrays.asList(this.createMessage("0"), this.createMessage("1"), this.createMessage("2"));
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messages);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
        }
    }

    private AnypointMqMessage createMessage(String postfix) {
        AnypointMqMessageBuilder messageBuilder = new AnypointMqMessageBuilder();
        messageBuilder.withMessageId("someMessageId" + (postfix != null ? postfix : ""));
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody("Some body");
        messageBuilder.addHeader("Some Header", "Some Header value");
        messageBuilder.addProperty("Some Property", "Some Property value");
        return messageBuilder.build();
    }

    @Test
    public void receive() throws Exception {
        this.setup(3);
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        List messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
        DefaultAnypointMqMessage message = (DefaultAnypointMqMessage)messages.get(0);
        Assert.assertThat((Object)message.getId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat(message.getHeaders().get("lockId"), (Matcher)Is.is((Object)"someLockId"));
        Assert.assertThat(message.getProperties().get("userDefinedProperty"), (Matcher)Is.is((Object)"User defined stuff"));
        Assert.assertThat(message.getProperties().get("anotherUserDefinedProperty"), (Matcher)Is.is((Object)"Random stuff"));
        Assert.assertThat((Object)message.getBodyAsString(), (Matcher)Is.is((Object)"This is a message payload"));
        observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void ack() throws Exception {
        this.setup(2);
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, new LockId("someMessageId", "someLockId"));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void ackBatch() throws Exception {
        this.setup(2);
        List<LockId> lockIds = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, lockIds);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test
    public void nack() throws Exception {
        this.setup(2);
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, new LockId("someMessageId", "someLockId"));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void nackBatch() throws Exception {
        this.setup(2);
        List<LockId> lockIds = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, lockIds);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test
    public void modifyTtl() throws Exception {
        this.setup(2);
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, new NewTtl("someMessageId", "someLockId", 1000L));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void modifyTtlBatch() throws Exception {
        this.setup(2);
        List<NewTtl> newTtls = Arrays.asList(this.getNewTtl("0"), this.getNewTtl("1"), this.getNewTtl("2"));
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, newTtls);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test(expected=RuntimeException.class)
    public void tooManyRequests() throws Exception {
        this.setup(1);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }

    @Test(expected=RuntimeException.class)
    public void tooFewRequests() throws Exception {
        this.setup(3);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
        this.tearDown();
    }

    @Test
    public void retryOnTokenExpiration() throws Exception {
        this.setup(4);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        this.server.setFailAuthOnNextRequest(true);
        List messages = (List)this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
        Assert.assertThat((Object)messages, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    private LockId getLockId(String postfix) {
        return new LockId("someMessageId" + postfix, "someLockId" + postfix);
    }

    private NewTtl getNewTtl(String postfix) {
        return new NewTtl("someMessageId" + postfix, "someLockId" + postfix, 1000L);
    }
}

