/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.internal.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestTimeSupplier;
import com.mulesoft.mq.restclient.internal.TestUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScheduledPrefetcherTest {
    public static final int POLLING_TIME = 500;
    private static final long START_TIME = 0L;
    private static final int SCHEDULE_FIXED_FREQUENCY = 1500;
    private static final String ID_ONE = "id-1";
    private static final String ID_TWO = "id-2";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String ID_THREE = "id-3";
    private static final String THREE = "3";
    @Mock
    private DefaultMessagePreserver preserver;
    private int batchSize;
    private long poolingTime;
    private long lockTimeToLive;
    private long frequency;
    private TestDestination destination;
    private ScheduledPrefetcher prefetcher;
    private ScheduledExecutorService executorService;

    @Before
    public void setup() {
        this.batchSize = 5;
        this.poolingTime = 500L;
        this.frequency = 1500L;
        this.lockTimeToLive = 120000L;
        this.destination = new TestDestination(new TestTimeSupplier(0L));
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.prefetcher = this.createPrefetcher(this.destination, this.batchSize, this.frequency, this.poolingTime, this.lockTimeToLive, this.executorService, this.preserver);
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.preserver.isExpired(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.preserver.remove(org.mockito.Matchers.anyString())).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.prefetcher.stop();
        this.executorService.shutdown();
    }

    @Test
    public void retrieveMessagesOnStart() {
        this.destination.send(ScheduledPrefetcherTest.createTestMessage(ONE));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)0));
        this.prefetcher.start();
        TestUtils.probe(600L, 200L, () -> MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void retrieveMessagePeriodicallyOnEmptyQueue() throws Exception {
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)0));
        this.prefetcher.start();
        TestUtils.probe(1000L, 200L, () -> MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1)));
        Thread.sleep(500L);
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
        TestUtils.probe(1500L, 300L, () -> MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)2)));
        Thread.sleep(500L);
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void prefetcherActsLikeAQueue() {
        this.destination.send(ScheduledPrefetcherTest.createTestMessage(ONE));
        this.destination.send(ScheduledPrefetcherTest.createTestMessage(TWO));
        this.destination.send(ScheduledPrefetcherTest.createTestMessage(THREE));
        this.prefetcher.start();
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver, (VerificationMode)Mockito.timeout((long)5000L).times(3))).add((AnypointMqMessage)Mockito.any(AnypointMqMessage.class), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_ONE));
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_TWO));
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_THREE));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void checkMessageExpiredOnCall() {
        AnypointMqMessage message = ScheduledPrefetcherTest.createTestMessage(ONE);
        this.destination.send(message);
        this.prefetcher.start();
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMqMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_ONE));
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver)).isExpired(ID_ONE);
    }

    @Test
    public void skipExpiredMessage() {
        Mockito.when((Object)this.preserver.isExpired((String)Mockito.eq((Object)ID_ONE))).thenReturn((Object)true);
        Mockito.when((Object)this.preserver.isExpired((String)Mockito.eq((Object)ID_TWO))).thenReturn((Object)false);
        AnypointMqMessage firstMessage = ScheduledPrefetcherTest.createTestMessage(ONE);
        AnypointMqMessage secondMessage = ScheduledPrefetcherTest.createTestMessage(TWO);
        this.destination.send(firstMessage);
        this.destination.send(secondMessage);
        this.prefetcher.start();
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver, (VerificationMode)Mockito.timeout((long)5000L).times(2))).add((AnypointMqMessage)Mockito.any(AnypointMqMessage.class), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_TWO));
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver)).isExpired(ID_ONE);
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver)).isExpired(ID_TWO);
    }

    @Test
    public void removeMessageOnCall() {
        AnypointMqMessage message = ScheduledPrefetcherTest.createTestMessage(ONE);
        this.destination.send(message);
        this.prefetcher.start();
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMqMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)ID_ONE));
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver)).remove(ID_ONE);
    }

    @Test
    public void addMessageToPreserverWhenNoConsumers() {
        AnypointMqMessage message = ScheduledPrefetcherTest.createTestMessage(ONE);
        this.destination.send(message);
        this.prefetcher.start();
        ((DefaultMessagePreserver)Mockito.verify((Object)this.preserver, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMqMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
    }

    private static AnypointMqMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, "body-" + id);
    }

    private ScheduledPrefetcher createPrefetcher(Destination destination, int batchSize, long frequency, long poolingTime, long lockTimeToLive, final ScheduledExecutorService executorService, DefaultMessagePreserver preserver) {
        return new ScheduledPrefetcher(destination, batchSize, poolingTime, lockTimeToLive, frequency, (MessagePreserver)preserver){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

