/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.internal.Utils;
import java.util.Map;

public final class DefaultAnypointMqMessage
implements AnypointMqMessage {
    private final String body;
    private final Map<String, String> headers;
    private final Map<String, String> properties;

    public DefaultAnypointMqMessage(String body, Map<String, String> headers, Map<String, String> properties) {
        Preconditions.checkArgument((headers != null ? 1 : 0) != 0, (Object)"Headers map cannot be null");
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Properties map cannot be null");
        this.body = body;
        this.headers = headers;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.headers.get("messageId");
    }

    @Override
    public String getLockId() {
        return this.headers.get("lockId");
    }

    @Override
    public int getDeliveryCount() {
        return Utils.toInt(this.headers.get("deliveryCount"), 1);
    }

    @Override
    public byte[] getBody() {
        return this.body != null ? this.body.getBytes(AnypointMqMessage.DEFAULT_BODY_CHARSET) : null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getBodyAsString() {
        return this.body;
    }
}

