/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.impl;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestTimeSupplier;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PrefetchedDestinationTestCase {
    @Mock
    private MQCircuitBreaker circuitBreaker;
    @Mock
    private MessagePreserver messagePreserver;
    private TestDestination testDestination;
    private PrefetchedDestination prefetchedDestination;
    private ScheduledPrefetcher prefetcher;

    @Before
    public void setup() {
        boolean startTime = false;
        int batchSize = 3;
        long pollingTime = 1000L;
        long retrieveFrequency = 5000L;
        long lockTimeToLive = 120000L;
        this.testDestination = new TestDestination(new TestTimeSupplier(0L));
        Mockito.when((Object)this.messagePreserver.isExpired(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.messagePreserver.remove(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.getState()).thenReturn((Object)MQCircuitBreaker.CircuitState.CLOSED);
        Mockito.when((Object)this.circuitBreaker.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.circuitBreaker.isOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.isHalfOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.acquireCircuitLock()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.releaseCircuitLock()).thenReturn((Object)false);
        this.prefetcher = new ScheduledPrefetcher((Destination)this.testDestination, 3, 1000L, 120000L, 5000L, this.messagePreserver, this.circuitBreaker);
        this.prefetchedDestination = new PrefetchedDestination((Destination)this.testDestination, (Prefetcher)this.prefetcher);
    }

    @After
    public void tearDown() {
        this.prefetcher.stop();
    }

    @Test
    public void retrieveMessagesOnlyOnceManyGets() {
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("0"));
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("1"));
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("2"));
        this.prefetcher.start();
        ArrayList<String> ids = new ArrayList<String>(3);
        ids.add(((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId());
        ids.add(((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId());
        ids.add(((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId());
        Assert.assertThat(ids, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"id-0", "id-1", "id-2"}));
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
    }

    private static AnypointMqMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, "body-" + id);
    }
}

