/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.impl;

import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.DestinationLocation;
import com.mulesoft.mq.restclient.api.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.api.DestinationLocator;
import com.mulesoft.mq.restclient.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.impl.DefaultDestination;
import com.mulesoft.mq.restclient.internal.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.internal.CourierRestClient;
import com.mulesoft.mq.restclient.internal.Utils;

public class DefaultDestinationLocator
implements DestinationLocator {
    private final CourierRestClient client;

    public DefaultDestinationLocator(CourierRestClient client) {
        this.client = client;
    }

    @Override
    public CourierObservable<Destination> getDestination(DestinationLocation destinationLocation) {
        Utils.checkNotNull(destinationLocation, "destinationLocation cannot be null");
        return new DefaultCourierObservable<Destination>(new DefaultDestination(this.client, destinationLocation));
    }

    @Override
    public DestinationLocation getDefaultDestinationLocation(String destinationName) {
        Utils.checkNotNull(destinationName, "destinationName cannot be null");
        return this.createDefaultDestinationLocationBuilder().setName(destinationName).build();
    }

    private DestinationLocationBuilder createDefaultDestinationLocationBuilder() {
        if (this.client instanceof AbstractCourierRestClient) {
            return ((AbstractCourierRestClient)this.client).getDefaultDestinationLocationBuilder();
        }
        return new DestinationLocationBuilder().setOrganizationId("no-org").setEnvironmentId("no-env");
    }
}

