/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.impl;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.impl.PreservedMessagesDestination;
import com.mulesoft.mq.restclient.internal.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.InvokerTestTimeSupplier;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestScheduledExecutorService;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PreservedMessagesDestinationTestCase {
    private InvokerTestTimeSupplier timeSupplier;
    private TestDestination testDestination;
    private PreservedMessagesDestination preservedMessagesDestination;

    @Before
    public void setup() {
        boolean startTime = false;
        TestScheduledExecutorService executorService = new TestScheduledExecutorService();
        this.timeSupplier = new InvokerTestTimeSupplier(0L, executorService);
        this.testDestination = new TestDestination(this.timeSupplier);
        MessagePreserver preserver = this.createPreserver(this.testDestination, this.timeSupplier, executorService);
        this.preservedMessagesDestination = new PreservedMessagesDestination((Destination)this.testDestination, preserver);
    }

    @Test
    public void receivedMessagesShouldBePreserved() {
        this.preservedMessagesDestination.send(PreservedMessagesDestinationTestCase.createTestMessage("0"));
        List messages = (List)this.preservedMessagesDestination.receive(1, 0L, 10000L).getValue();
        Assert.assertThat((Object)((AnypointMqMessage)messages.get(0)).getId(), (Matcher)Is.is((Object)"id-0"));
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(8001L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMillisecondsRealTime(8500L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
        this.timeSupplier.addMillisecondsRealTime(17000L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void ackFromDestinationShouldStopPreservation() {
        this.preservedMessagesDestination.send(PreservedMessagesDestinationTestCase.createTestMessage("0"));
        List messages = (List)this.preservedMessagesDestination.receive(1, 0L, 10000L).getValue();
        Assert.assertThat((Object)((AnypointMqMessage)messages.get(0)).getId(), (Matcher)Is.is((Object)"id-0"));
        this.timeSupplier.addMillisecondsRealTime(16501L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
        this.preservedMessagesDestination.ack(messages).fireAndForget();
        this.timeSupplier.addMillisecondsRealTime(17000L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void ackFromMessageShouldStopPreservation() {
        this.preservedMessagesDestination.send(PreservedMessagesDestinationTestCase.createTestMessage("0"));
        List messages = (List)this.preservedMessagesDestination.receive(1, 0L, 10000L).getValue();
        Assert.assertThat((Object)((AnypointMqMessage)messages.get(0)).getId(), (Matcher)Is.is((Object)"id-0"));
        this.timeSupplier.addMillisecondsRealTime(16501L);
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
        this.testDestination.ack((AnypointMqMessage)messages.get(0));
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
    }

    private static AnypointMqMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, "body-" + id);
    }

    private MessagePreserver createPreserver(Destination destination, TimeSupplier timeSupplier, final ScheduledExecutorService executorService) {
        return new DefaultMessagePreserver(destination, timeSupplier){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

