/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.internal.DefaultAnypointMqMessage;
import com.mulesoft.mq.restclient.internal.DefaultMessageIdResult;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    protected static final Type STRING_OBJECT_MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    protected static final Type MESSAGES_LIST_TYPE = new TypeToken<List<DefaultAnypointMqMessage>>(){}.getType();
    protected static final Type MESSAGE_ID_RESULT_TYPE = new TypeToken<DefaultMessageIdResult>(){}.getType();
    protected static final Type MESSAGE_IDS_RESULT_TYPE = new TypeToken<List<DefaultMessageIdResult>>(){}.getType();

    public static <T> T fromJson(String json, Type resultType) {
        return (T)new Gson().fromJson(json, resultType);
    }

    public static String extractValueFromJson(String json, String valueName) {
        return JsonUtils.toString(((Map)JsonUtils.fromJson(json, STRING_OBJECT_MAP_TYPE)).get(valueName));
    }

    protected static String toString(Object o) {
        return o != null ? o.toString() : null;
    }

    public static Map<String, String> extractMapValueFromJson(String json, String propertyName) {
        return (Map)((Map)JsonUtils.fromJson(json, STRING_OBJECT_MAP_TYPE)).get(propertyName);
    }

    public static String toJson(String ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return JsonUtils.toJson(map);
    }

    public static <T> String toJson(T src) {
        return new Gson().toJson(src);
    }

    public static List<DefaultAnypointMqMessage> courierRestMessagesFromJson(String json) {
        return (List)JsonUtils.fromJson(json, MESSAGES_LIST_TYPE);
    }

    public static MessageIdResult messageIdResultFromJson(String json) {
        return (MessageIdResult)JsonUtils.fromJson(json, MESSAGE_ID_RESULT_TYPE);
    }

    public static List<MessageIdResult> messageIdResultsFromJson(String json) {
        return (List)JsonUtils.fromJson(json, MESSAGE_IDS_RESULT_TYPE);
    }
}

