/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    protected static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final String USER_AGENT_VERSION_PROPERTY_NAME = "user-agent.version";
    private static final String CONFIGURATION_PROPERTIES_FILE = "/anypoint-mq-rest-client.properties";
    private static Properties configuration;

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotNull(Object argument, String message) {
        Utils.checkArgument(argument != null, message);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = inputStream.read()) != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String getUserAgentVersion() {
        return Utils.getConfiguration().getProperty(USER_AGENT_VERSION_PROPERTY_NAME);
    }

    public static String getUserAgent() {
        return "Mule Anypoint MQ/" + Utils.getUserAgentVersion();
    }

    private static Properties getConfiguration() {
        if (configuration == null) {
            configuration = new Properties();
            try {
                configuration.load(Utils.class.getResourceAsStream(CONFIGURATION_PROPERTIES_FILE));
            }
            catch (Exception e) {
                logger.warn("Cannot read configuration file: " + Utils.class.getResource(CONFIGURATION_PROPERTIES_FILE).getFile(), (Throwable)e);
            }
        }
        return configuration;
    }
}

