/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.AnypointMqMessageBuilder;
import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.LockedMessage;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.DefaultMessageIdResult;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import rx.Observable;

public class TestDestination
implements Destination {
    private static final String DEFAULT_NAME = "Test Destination";
    private final String name;
    private final Queue<AnypointMqMessage> queue;
    private final TimeSupplier timeSupplier;
    private int receiveCount;
    private long lastReceiveTime;
    private int modifyLockIntervalCount;
    private Map<String, Integer> modifyLockIntervalCountPerMessage;
    private ExecutorService executorService;

    public TestDestination(TimeSupplier timeSupplier) {
        this(DEFAULT_NAME, timeSupplier);
    }

    public TestDestination(String name, TimeSupplier timeSupplier) {
        this.name = name;
        this.queue = new LinkedList<AnypointMqMessage>();
        this.timeSupplier = timeSupplier;
        this.lastReceiveTime = -1L;
        this.modifyLockIntervalCountPerMessage = new HashMap<String, Integer>();
        this.executorService = Executors.newScheduledThreadPool(4);
    }

    public int getReceiveCount() {
        return this.receiveCount;
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public int getModifyLockIntervalCount() {
        return this.modifyLockIntervalCount;
    }

    public int getModifyLockIntervalCount(String messageId) {
        Integer count = this.modifyLockIntervalCountPerMessage.get(messageId);
        return count != null ? count : 0;
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public CourierObservable<MessageIdResult> send(AnypointMqMessage message) {
        return new DefaultCourierObservable((Object)this.addToQueue(message));
    }

    private MessageIdResult addToQueue(AnypointMqMessage message) {
        return this.queue.offer(message) ? this.createSuccessfulMessageIdResult(message) : this.createErrorlMessageIdResult(message);
    }

    public CourierObservable<List<MessageIdResult>> send(List<AnypointMqMessage> messages) {
        ArrayList<MessageIdResult> results = new ArrayList<MessageIdResult>();
        for (AnypointMqMessage message : messages) {
            results.add(this.addToQueue(message));
        }
        return new DefaultCourierObservable(results);
    }

    public CourierObservable<List<AnypointMqMessage>> receive() {
        return this.receive(1, 0L, 0L);
    }

    public CourierObservable<List<AnypointMqMessage>> receive(int batchSize, long pollingTime, long lockTtl) {
        Observable objectObservable = Observable.create(subscriber -> this.executorService.submit(() -> {
            ArrayList<AnypointMqMessage> result = new ArrayList<AnypointMqMessage>();
            if (!this.queue.isEmpty()) {
                for (int i = 0; i < batchSize && !this.queue.isEmpty(); ++i) {
                    result.add(this.queue.poll());
                }
            } else {
                try {
                    Thread.sleep(pollingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.receiveCount;
            this.lastReceiveTime = this.timeSupplier.get();
            subscriber.onNext(result);
            subscriber.onCompleted();
        }));
        return new DefaultCourierObservable(objectObservable);
    }

    private CourierObservable<List<MessageIdResult>> createSuccessResults(List<AnypointMqMessage> messages) {
        List results = messages.stream().map(this::createSuccessfulMessageIdResult).collect(Collectors.toList());
        return new DefaultCourierObservable(results);
    }

    private CourierObservable<MessageIdResult> createSuccessResults(AnypointMqMessage message) {
        return new DefaultCourierObservable((Object)this.createSuccessfulMessageIdResult(message));
    }

    public CourierObservable<List<MessageIdResult>> ack(List<AnypointMqMessage> messages) {
        return this.createSuccessResults(messages);
    }

    public CourierObservable<MessageIdResult> ack(AnypointMqMessage message) {
        return this.createSuccessResults(message);
    }

    public CourierObservable<List<MessageIdResult>> nack(List<AnypointMqMessage> messages) {
        return this.createSuccessResults(messages);
    }

    public CourierObservable<MessageIdResult> nack(AnypointMqMessage message) {
        return this.createSuccessResults(message);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMqMessage> messages, int lockInterval) {
        ++this.modifyLockIntervalCount;
        for (AnypointMqMessage message : messages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(message.getId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(message.getId(), count);
        }
        return this.createSuccessResults(messages);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        ++this.modifyLockIntervalCount;
        ArrayList<AnypointMqMessage> messages = new ArrayList<AnypointMqMessage>();
        for (LockedMessage lockedMessage : lockedMessages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(lockedMessage.getMessage().getId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(lockedMessage.getMessage().getId(), count);
            messages.add(lockedMessage.getMessage());
        }
        return this.createSuccessResults(messages);
    }

    public AnypointMqMessageBuilder newMessageBuilder() {
        return null;
    }

    private MessageIdResult createSuccessfulMessageIdResult(AnypointMqMessage message) {
        return new DefaultMessageIdResult(message.getId(), "successful", "");
    }

    private MessageIdResult createErrorlMessageIdResult(AnypointMqMessage message) {
        return new DefaultMessageIdResult(message.getId(), "ERROR", "");
    }
}

