/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.DestinationLocation;
import com.mulesoft.mq.restclient.api.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.CourierRestClient;
import com.mulesoft.mq.restclient.internal.CourierUrlBuilder;
import com.mulesoft.mq.restclient.internal.DefaultAnypointMqMessage;
import com.mulesoft.mq.restclient.internal.ExceptionFactory;
import com.mulesoft.mq.restclient.internal.JsonUtils;
import com.mulesoft.mq.restclient.internal.LockId;
import com.mulesoft.mq.restclient.internal.MessageUtils;
import com.mulesoft.mq.restclient.internal.NewTtl;
import com.mulesoft.mq.restclient.internal.Request;
import com.mulesoft.mq.restclient.internal.RequestBuilder;
import com.mulesoft.mq.restclient.internal.Response;
import com.mulesoft.mq.restclient.internal.Utils;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.BlockingObservable;
import rx.schedulers.Schedulers;

public abstract class AbstractCourierRestClient
implements CourierRestClient {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCourierRestClient.class);
    private static final String AUTHENTICATION_TOKEN_TYPE = "Bearer ";
    public static long DEFAULT_TIMEOUT_MILLIS = 20000L;
    private static final List<DefaultAnypointMqMessage> EMPTY_MESSAGES_LIST = Collections.emptyList();
    private static final int MAX_GET_ACCESS_TOKEN_RETRIES = 5;
    protected static final int EXTRA_RECEIVE_TIMEOUT = 2000;
    private final CourierUrlBuilder courierUrlBuilder;
    private final OAuthCredentials oAuthCredentials;
    private final String userAgentInfo;
    private BlockingObservable<Response> observableAccessTokenResponse;
    private String accessToken;
    private String defaultOrganizationId;
    private String defaultEnvironmentId;
    private static final int MAX_RETRIES = Integer.getInteger("max.retries.failure.operation", 5);
    private static final long BACK_OFF_MULTIPLIER = Long.parseLong(System.getProperty("object.store.client.back.off.multiplier", "2"));
    private static final long BACK_OFF_INITIAL_WAIT = Long.parseLong(System.getProperty("object.store.client.back.off.initial.wait", "1000"));

    public AbstractCourierRestClient(String courierApiUrl, OAuthCredentials oAuthCredentials, String userAgentInfo) {
        this.courierUrlBuilder = new CourierUrlBuilder(courierApiUrl);
        this.oAuthCredentials = oAuthCredentials;
        this.userAgentInfo = userAgentInfo == null || userAgentInfo.trim().isEmpty() ? Utils.getUserAgent() : userAgentInfo;
    }

    @Override
    public void init() {
        this.ensureAccessToken();
    }

    @Override
    public void dispose() {
    }

    protected long getTimeoutMillis(Long timeoutMillis) {
        return timeoutMillis != null ? timeoutMillis : DEFAULT_TIMEOUT_MILLIS;
    }

    public String getDefaultOrganizationId() {
        this.ensureAccessToken();
        return this.defaultOrganizationId;
    }

    public String getDefaultEnvironmentId() {
        this.ensureAccessToken();
        return this.defaultEnvironmentId;
    }

    protected void ensureAccessToken() {
        if (this.accessToken == null) {
            this.getAccessToken();
        }
    }

    public DestinationLocationBuilder getDefaultDestinationLocationBuilder() {
        return new DestinationLocationBuilder().setOrganizationId(this.getDefaultOrganizationId()).setEnvironmentId(this.getDefaultEnvironmentId());
    }

    public static boolean ofType(Throwable e, Class<? extends Throwable> type) {
        return e != null && type.isInstance(e);
    }

    public static boolean isTimeout(Throwable e) {
        return AbstractCourierRestClient.ofType(e, TimeoutException.class);
    }

    public static boolean withMessage(Throwable e, String message) {
        return e.getMessage() != null && e.getMessage().contains(message);
    }

    public static boolean isConnectionInterrupted(Throwable e) {
        return AbstractCourierRestClient.ofType(e, IOException.class) && AbstractCourierRestClient.withMessage(e, "Remotely closed");
    }

    public static boolean isConnectionRefused(Throwable e) {
        return AbstractCourierRestClient.ofType(e, ConnectException.class) && AbstractCourierRestClient.withMessage(e, "Connection refused");
    }

    @Override
    public Observable<List<DefaultAnypointMqMessage>> receive(DestinationLocation destinationLocation, int batchSize, long poolingTime, long lockTtl) {
        RequestBuilder requestBuilder = this.newRequestBuilderWithAgent().use(RequestBuilder.Method.GET).to(this.courierUrlBuilder.messages(destinationLocation));
        if (batchSize > 1) {
            requestBuilder.withQueryParam("batchSize", Integer.toString(batchSize));
        }
        if (poolingTime > 0L) {
            requestBuilder.withQueryParam("poolingTime", Long.toString(poolingTime));
            requestBuilder.waitingUpTo(poolingTime + 2000L, TimeUnit.MILLISECONDS);
        }
        if (lockTtl > 0L) {
            requestBuilder.withQueryParam("lockTtl", Long.toString(lockTtl));
        }
        requestBuilder.withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken());
        return this.processWithRetry(requestBuilder.build()).flatMap((Func1)new Func1<Response, Observable<List<DefaultAnypointMqMessage>>>(){

            public Observable<List<DefaultAnypointMqMessage>> call(Response response) {
                try {
                    if (response.getStatusCode() == 204) {
                        return Observable.just((Object)EMPTY_MESSAGES_LIST);
                    }
                    if (response.isOk()) {
                        return Observable.just(JsonUtils.courierRestMessagesFromJson(response.getBody()));
                    }
                    return Observable.error((Throwable)ExceptionFactory.create("RECEIVE MESSAGES", response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create("RECEIVE MESSAGES", e));
                }
            }
        });
    }

    @Override
    public Observable<MessageIdResult> send(DestinationLocation destinationLocation, AnypointMqMessage message) {
        return this.oneResult("SEND ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PUT).to(this.courierUrlBuilder.message(destinationLocation, message.getId())).withBody(JsonUtils.toJson(message)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<List<MessageIdResult>> send(DestinationLocation destinationLocation, List<AnypointMqMessage> messages) {
        return this.manyResults("SEND MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PUT).to(this.courierUrlBuilder.messages(destinationLocation)).withBody(JsonUtils.toJson(messages)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<MessageIdResult> ack(DestinationLocation destinationLocation, LockId lockId) {
        return this.oneResult("ACK ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.message(destinationLocation, lockId.getMessageId())).withBody(JsonUtils.toJson("lockId", lockId.getLockId())).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<List<MessageIdResult>> ack(DestinationLocation destinationLocation, List<LockId> lockIds) {
        return this.manyResults("ACK MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.messages(destinationLocation)).withBody(JsonUtils.toJson(lockIds)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<MessageIdResult> nack(DestinationLocation destinationLocation, LockId lockId) {
        return this.oneResult("NOT-ACK ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.lock(destinationLocation, lockId.getMessageId(), lockId.getLockId())).withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<List<MessageIdResult>> nack(DestinationLocation destinationLocation, List<LockId> lockIds) {
        return this.manyResults("NOT-ACK MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.locks(destinationLocation)).withBody(JsonUtils.toJson(lockIds)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<MessageIdResult> modifyTtl(DestinationLocation destinationLocation, NewTtl newTtl) {
        return this.oneResult("MODIFY TTL ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PATCH).to(this.courierUrlBuilder.lock(destinationLocation, newTtl.getMessageId(), newTtl.getLockId())).withBody(JsonUtils.toJson("ttl", Long.toString(newTtl.getTtl()))).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    @Override
    public Observable<List<MessageIdResult>> modifyTtl(DestinationLocation destinationLocation, List<NewTtl> newTtls) {
        return this.manyResults("MODIFY TTL MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PATCH).to(this.courierUrlBuilder.locks(destinationLocation)).withBody(JsonUtils.toJson(newTtls)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.getAccessToken()).build()));
    }

    private synchronized void resetAccessToken() {
        if (this.accessToken == null && this.observableAccessTokenResponse != null) {
            return;
        }
        this.accessToken = null;
        this.observableAccessTokenResponse = this.process(this.createAuthRequest()).toBlocking();
    }

    private Request createAuthRequest() {
        return this.newRequestBuilderWithAgent().use(RequestBuilder.Method.POST).to(this.courierUrlBuilder.authorizeUrl()).withHeader("Content-Type", "application/x-www-form-urlencoded").withBody("client_id=" + this.oAuthCredentials.getClientId() + "&client_secret=" + this.oAuthCredentials.getClientSecret() + "&grant_type=client_credentials").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        Response accessTokenResponse = null;
        Exception lastException = null;
        AbstractCourierRestClient abstractCourierRestClient = this;
        synchronized (abstractCourierRestClient) {
            if (this.accessToken == null) {
                if (this.observableAccessTokenResponse == null) {
                    this.resetAccessToken();
                }
                for (int accessTokenRetries = 0; this.accessToken == null && accessTokenRetries < 5; ++accessTokenRetries) {
                    accessTokenResponse = null;
                    try {
                        accessTokenResponse = (Response)this.observableAccessTokenResponse.first();
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                    if (accessTokenResponse == null || !accessTokenResponse.isOk()) continue;
                    this.parseAccessTokenResponse(accessTokenResponse);
                }
            }
        }
        if (this.accessToken != null) {
            return this.accessToken;
        }
        throw ExceptionFactory.create("AUTHORIZE AGAINST BROKER", accessTokenResponse, "Can not login into broker. " + this.friendlyMessage(accessTokenResponse), lastException);
    }

    private void parseAccessTokenResponse(Response accessTokenResponse) {
        String body = accessTokenResponse.getBody();
        this.accessToken = JsonUtils.extractValueFromJson(body, "access_token");
        Map<String, String> simpleClient = JsonUtils.extractMapValueFromJson(body, "simple_client");
        if (simpleClient != null) {
            this.defaultOrganizationId = simpleClient.get("orgId");
            this.defaultEnvironmentId = simpleClient.get("envId");
        }
    }

    private String friendlyMessage(Response response) {
        if (response != null) {
            switch (response.getStatusCode()) {
                case 401: {
                    return "NOT AUTHORISED";
                }
            }
            return String.format("%d - %s (%s)", response.getStatusCode(), response.getStatusText(), response.getBody());
        }
        return "";
    }

    private Observable<Response> processWithRetry(Request request) {
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        exponentialBackOff.setMultiplier((double)BACK_OFF_MULTIPLIER);
        exponentialBackOff.setInitialInterval(BACK_OFF_INITIAL_WAIT);
        BackOffExecution backOffExecution = exponentialBackOff.start();
        return this.internalProcessWithRetry(request, null, null, MAX_RETRIES + 1, backOffExecution);
    }

    private Observable<Response> internalProcessWithRetry(final Request request, Response res, Throwable throwable, final int remaining, final BackOffExecution exponentialBackOff) {
        if (remaining <= 0) {
            return this.getErrorResponse(res, throwable);
        }
        return this.internalProcess(request).flatMap((Func1)new Func1<Response, Observable<? extends Response>>(){

            public Observable<? extends Response> call(Response response) {
                if (response.getStatusCode() >= 500 && response.getStatusCode() <= 599) {
                    return AbstractCourierRestClient.this.getRetryObservable(request, response, exponentialBackOff, null, remaining - 1);
                }
                return Observable.just((Object)response);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends Response>>(){

            public Observable<? extends Response> call(Throwable th) {
                return AbstractCourierRestClient.this.getRetryObservable(request, null, exponentialBackOff, th, remaining - 1);
            }
        });
    }

    private Observable<Response> getErrorResponse(Response res, Throwable throwable) {
        if (throwable != null) {
            logger.error("There was an error processing operation after {} retries", (Object)MAX_RETRIES, (Object)throwable);
            return Observable.error((Throwable)throwable);
        }
        return Observable.just((Object)res);
    }

    private Observable<? extends Response> getRetryObservable(final Request request, final Response response, final BackOffExecution exponentialBackOff, final Throwable throwable, final int remaining) {
        if (remaining == 0 || throwable instanceof RejectedExecutionException) {
            return this.getErrorResponse(response, throwable);
        }
        return Observable.defer((Func0)new Func0<Observable<Response>>(){

            public Observable<Response> call() {
                long nextBackOff = exponentialBackOff.nextBackOff();
                logger.debug("There was an error processing operation retrying in {}ms, remaining attempts {}", new Object[]{nextBackOff, remaining, throwable});
                return Observable.timer((long)nextBackOff, (TimeUnit)TimeUnit.MILLISECONDS).flatMap((Func1)new Func1<Long, Observable<? extends Response>>(){

                    public Observable<? extends Response> call(Long aLong) {
                        return AbstractCourierRestClient.this.internalProcessWithRetry(request, response, throwable, remaining, exponentialBackOff);
                    }
                });
            }
        });
    }

    private Observable<Response> internalProcess(final Request request) {
        return this.process(request).flatMap((Func1)new Func1<Response, Observable<Response>>(){

            public Observable<Response> call(Response response) {
                if (response.isUnauthorized()) {
                    return AbstractCourierRestClient.this.regenerateTokenAndRetry(request);
                }
                return Observable.just((Object)response);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<Response>>(){

            public Observable<Response> call(Throwable throwable) {
                if (AbstractCourierRestClient.this.isUnauthorized(throwable)) {
                    return AbstractCourierRestClient.this.regenerateTokenAndRetry(request);
                }
                logger.debug("An error occurred while processing request {}", (Object)request.toString(), (Object)throwable);
                return Observable.error((Throwable)throwable);
            }
        });
    }

    private Observable<Response> regenerateTokenAndRetry(final Request request) {
        return Observable.just(null).observeOn(Schedulers.newThread()).flatMap((Func1)new Func1<Object, Observable<Response>>(){

            public Observable<Response> call(Object empty) {
                AbstractCourierRestClient.this.resetAccessToken();
                Request retryRequest = AbstractCourierRestClient.this.newRequestBuilderWithAgent().wrap(request).withHeader("Authorization", AbstractCourierRestClient.AUTHENTICATION_TOKEN_TYPE + AbstractCourierRestClient.this.getAccessToken()).build();
                return AbstractCourierRestClient.this.process(retryRequest);
            }
        });
    }

    private boolean isUnauthorized(Throwable throwable) {
        return AbstractCourierRestClient.ofType(throwable, IllegalStateException.class) && AbstractCourierRestClient.withMessage(throwable, "401 response received, but no WWW-Authenticate header was present");
    }

    private Observable<MessageIdResult> oneResult(final String operation, Observable<Response> responseObservable) {
        return responseObservable.flatMap((Func1)new Func1<Response, Observable<MessageIdResult>>(){

            public Observable<MessageIdResult> call(Response response) {
                try {
                    if (response.isOk()) {
                        return Observable.just((Object)JsonUtils.messageIdResultFromJson(response.getBody()));
                    }
                    return Observable.error((Throwable)ExceptionFactory.create(operation, response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create(operation, e));
                }
            }
        });
    }

    private Observable<List<MessageIdResult>> manyResults(final String operation, Observable<Response> responseObservable) {
        return responseObservable.flatMap((Func1)new Func1<Response, Observable<List<MessageIdResult>>>(){

            public Observable<List<MessageIdResult>> call(Response response) {
                try {
                    if (response.isOk()) {
                        return Observable.just(JsonUtils.messageIdResultsFromJson(response.getBody()));
                    }
                    return Observable.error((Throwable)ExceptionFactory.create(operation, response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create(operation, e));
                }
            }
        });
    }

    protected void logProcessStart(Request request) {
        logger.debug("Sending {} request to {}", (Object)request.getMethod(), (Object)request.getUrl());
    }

    protected void logProcessSuccess(Request request, Response response) {
        logger.debug("Received response from {} {}. Request Id: {}", new Object[]{request.getMethod(), request.getUrl(), this.getRequestId(response)});
    }

    protected void logProcessError(Request request, Throwable e) {
        if (AbstractCourierRestClient.isTimeout(e)) {
            logger.debug("Request timed out from {} {}.", (Object)request.getMethod(), (Object)request.getUrl());
        } else if (AbstractCourierRestClient.isConnectionInterrupted(e)) {
            logger.error(String.format("Connection unexpectedly closed from %s %s.", new Object[]{request.getMethod(), request.getUrl()}));
            logger.debug(String.format("Connection unexpectedly closed from %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        } else if (AbstractCourierRestClient.isConnectionRefused(e)) {
            logger.error(String.format("Can not connect to broker for %s %s.", new Object[]{request.getMethod(), request.getUrl()}));
            logger.debug(String.format("Can not connect to broker for %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        } else {
            logger.error(String.format("Error from %s %s. %s", new Object[]{request.getMethod(), request.getUrl(), MessageUtils.getCompleteMessage(e)}));
            logger.debug(String.format("Error from %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        }
    }

    private String getRequestId(Response response) {
        try {
            String requestId = response.getHeader("X-Request-Id");
            if (requestId == null || requestId.isEmpty()) {
                requestId = "No-Id";
            }
            return requestId;
        }
        catch (Exception e) {
            return "No-Id";
        }
    }

    private RequestBuilder newRequestBuilderWithAgent() {
        return this.newRequestBuilder().withHeader("User-Agent", this.userAgentInfo);
    }

    protected abstract RequestBuilder newRequestBuilder();

    protected abstract Observable<Response> process(Request var1);
}

