/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.internal.BufferedQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferedQueue
implements BufferedQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBufferedQueue.class);
    private final BlockingQueue<AnypointMqMessage> bufferQueue = new LinkedBlockingQueue<AnypointMqMessage>();

    @Override
    public void add(AnypointMqMessage message) {
        LOGGER.debug("Adding message '{}'", (Object)message.getId());
        this.bufferQueue.add(message);
    }

    @Override
    public AnypointMqMessage take() {
        LOGGER.debug("Taking message from buffer");
        return (AnypointMqMessage)this.bufferQueue.poll();
    }

    @Override
    public void clear() {
        this.bufferQueue.clear();
    }

    @Override
    public int size() {
        return this.bufferQueue.size();
    }
}

