/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.api.exception.RestException;
import com.mulesoft.mq.restclient.internal.Response;

public class ExceptionFactory {
    public static RestException create(String operation, Exception e) {
        return new RestException(ExceptionFactory.createExceptionMessage(operation, null), e);
    }

    public static RestException create(String operation, Response response, String message) {
        return ExceptionFactory.create(operation, response, message, null);
    }

    public static RestException create(String operation, Response response, String message, Exception cause) {
        if (response != null && response.getStatusCode() == 404) {
            return new ResourceNotFoundException(ExceptionFactory.createExceptionMessage(operation, message), cause);
        }
        return new RestException(ExceptionFactory.createExceptionMessage(operation, message), cause);
    }

    private static String createExceptionMessage(String operation, String message) {
        return String.format("An error occurred while processing the response for the operation: %s. Cause: %s.", operation, message != null ? message : "-");
    }
}

