/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.internal.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.InvokerTestTimeSupplier;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import com.mulesoft.mq.restclient.utils.TestDestination;
import com.mulesoft.mq.restclient.utils.TestMessage;
import com.mulesoft.mq.restclient.utils.TestScheduledExecutorService;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagePreserverTestCase {
    private TestDestination testDestination;
    private DefaultMessagePreserver preserver;
    private InvokerTestTimeSupplier timeSupplier;

    @Before
    public void setup() {
        boolean startTime = false;
        TestScheduledExecutorService executorService = new TestScheduledExecutorService();
        this.timeSupplier = new InvokerTestTimeSupplier(0L, executorService);
        this.testDestination = new TestDestination(this.timeSupplier);
        this.preserver = this.createPreserver(this.testDestination, this.timeSupplier, executorService);
    }

    @Test
    public void addedMessagesShouldBePreserved() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMQMessage)message, 10000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(1000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(3999L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(2L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(MessagePreserverTestCase.id("0")), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMillisecondsRealTime(5500L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(MessagePreserverTestCase.id("0")), (Matcher)Is.is((Object)2));
    }

    @Test
    public void removedMessagesShouldNotBePreservedAnymore() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMQMessage)message, 10000L);
        this.timeSupplier.addMillisecondsRealTime(8001L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.preserver.remove(MessagePreserverTestCase.id("0"));
        this.timeSupplier.addMillisecondsRealTime(8500L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMillisecondsRealTime(17000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void messageIsExpiredAfterTtl() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMQMessage)message, 10000L);
        this.timeSupplier.addMilliseconds(8001L);
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)false));
        this.timeSupplier.addMilliseconds(13000L);
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void expiredMessageShouldNotBeUpdated() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMQMessage)message, 10000L);
        this.timeSupplier.addMilliseconds(8001L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMilliseconds(13000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMilliseconds(17000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void expiredMessageShouldBeKeptUntilRemoval() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMQMessage)message, 10000L);
        this.timeSupplier.addMilliseconds(8000L);
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)false));
        this.timeSupplier.addMilliseconds(13000L);
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)true));
        this.timeSupplier.addMilliseconds(13000L);
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.preserver.remove(message.getMessageId()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.preserver.isExpired(message.getMessageId()), (Matcher)Is.is((Object)false));
    }

    private static TestMessage createTestMessage(String suffix) {
        return new TestMessage(MessagePreserverTestCase.id(suffix), IOUtils.toInputStream((String)("body-" + suffix), (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
    }

    private static String id(String suffix) {
        return "id-" + suffix;
    }

    private DefaultMessagePreserver createPreserver(Destination destination, TimeSupplier timeSupplier, final ScheduledExecutorService executorService) {
        return new DefaultMessagePreserver(destination, timeSupplier){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

