/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.internal.AnypointMQReceiveBatchResponse;
import com.mulesoft.mq.restclient.internal.DefaultMessageIdResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static final Type STRING_OBJECT_MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Type MESSAGES_LIST_TYPE = new TypeToken<List<AnypointMQReceiveBatchResponse>>(){}.getType();
    private static final Type MESSAGE_ID_RESULT_TYPE = new TypeToken<DefaultMessageIdResult>(){}.getType();
    private static final Type MESSAGE_IDS_RESULT_TYPE = new TypeToken<List<DefaultMessageIdResult>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(InputStream.class, (Object)new TypeAdapter<InputStream>(){

        public void write(JsonWriter jsonWriter, InputStream inputStream) throws IOException {
            jsonWriter.value(IOUtils.toString((InputStream)inputStream, (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        }

        public InputStream read(JsonReader jsonReader) throws IOException {
            return IOUtils.toInputStream((String)jsonReader.nextString(), (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET);
        }
    }).create();

    public static <T> T fromJson(String json, Type resultType) {
        return (T)GSON.fromJson(json, resultType);
    }

    public static String extractValueFromJson(String json, String valueName) {
        return JsonUtils.toString(((Map)JsonUtils.fromJson(json, STRING_OBJECT_MAP_TYPE)).get(valueName));
    }

    protected static String toString(Object o) {
        return o != null ? o.toString() : null;
    }

    public static Map<String, String> extractMapValueFromJson(String json, String propertyName) {
        return (Map)((Map)JsonUtils.fromJson(json, STRING_OBJECT_MAP_TYPE)).get(propertyName);
    }

    public static String toJson(String ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return JsonUtils.toJson(map);
    }

    public static <T> String toJson(T src) {
        return GSON.toJson(src);
    }

    public static List<AnypointMQMessage> courierRestMessagesFromJson(String json) {
        List restMessages;
        ArrayList<AnypointMQMessage> messages = new ArrayList<AnypointMQMessage>();
        try {
            restMessages = (List)JsonUtils.fromJson(json, MESSAGES_LIST_TYPE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Json deserialization error - " + e.getMessage(), e);
        }
        for (AnypointMQReceiveBatchResponse restMessage : restMessages) {
            messages.add(restMessage.convertToAnypointMQMessage());
        }
        return messages;
    }

    public static MessageIdResult messageIdResultFromJson(String json) {
        return (MessageIdResult)JsonUtils.fromJson(json, MESSAGE_ID_RESULT_TYPE);
    }

    public static List<MessageIdResult> messageIdResultsFromJson(String json) {
        return (List)JsonUtils.fromJson(json, MESSAGE_IDS_RESULT_TYPE);
    }
}

