/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.Lock;
import com.mulesoft.mq.restclient.api.LockedMessage;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.DefaultMessageIdResult;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import rx.Observable;

public class TestDestination
implements Destination {
    private static final String DEFAULT_NAME = "Test Destination";
    private final Queue<AnypointMQMessage> queue = new LinkedList<AnypointMQMessage>();
    private final TimeSupplier timeSupplier;
    private int receiveCount;
    private long lastReceiveTime;
    private int modifyLockIntervalCount;
    private Map<String, Integer> modifyLockIntervalCountPerMessage;
    private ExecutorService executorService;

    public TestDestination(TimeSupplier timeSupplier) {
        this(DEFAULT_NAME, timeSupplier);
    }

    public TestDestination(String name, TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.lastReceiveTime = -1L;
        this.modifyLockIntervalCountPerMessage = new HashMap<String, Integer>();
        this.executorService = Executors.newScheduledThreadPool(4);
    }

    public int getReceiveCount() {
        return this.receiveCount;
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public int getModifyLockIntervalCount() {
        return this.modifyLockIntervalCount;
    }

    public int getModifyLockIntervalCount(String messageId) {
        Integer count = this.modifyLockIntervalCountPerMessage.get(messageId);
        return count != null ? count : 0;
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public CourierObservable<MessageIdResult> send(AnypointMQMessage message) {
        return new DefaultCourierObservable((Object)this.addToQueue(message));
    }

    private MessageIdResult addToQueue(AnypointMQMessage message) {
        return this.queue.offer(message) ? this.createSuccessfulMessageIdResult(message) : this.createErrorlMessageIdResult(message);
    }

    public CourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages) {
        ArrayList<MessageIdResult> results = new ArrayList<MessageIdResult>();
        for (AnypointMQMessage message : messages) {
            results.add(this.addToQueue(message));
        }
        return new DefaultCourierObservable(results);
    }

    public CourierObservable<List<AnypointMQMessage>> receive() {
        return this.receive(1, 0L, 0L);
    }

    public CourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl) {
        Observable objectObservable = Observable.create(subscriber -> this.executorService.submit(() -> {
            ArrayList<AnypointMQMessage> result = new ArrayList<AnypointMQMessage>();
            if (!this.queue.isEmpty()) {
                for (int i = 0; i < batchSize && !this.queue.isEmpty(); ++i) {
                    result.add(this.queue.poll());
                }
            } else {
                try {
                    Thread.sleep(pollingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.receiveCount;
            this.lastReceiveTime = this.timeSupplier.get();
            subscriber.onNext(result);
            subscriber.onCompleted();
        }));
        return new DefaultCourierObservable(objectObservable);
    }

    public CourierObservable<List<MessageIdResult>> ack(List<Lock> locks) {
        return this.createSuccessResultsWithLocks(locks);
    }

    public CourierObservable<MessageIdResult> ack(Lock lock) {
        return this.createSuccessResultsWithLock(lock);
    }

    public CourierObservable<List<MessageIdResult>> nack(List<Lock> locks) {
        return this.createSuccessResultsWithLocks(locks);
    }

    public CourierObservable<MessageIdResult> nack(Lock lock) {
        return this.createSuccessResultsWithLock(lock);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval) {
        ++this.modifyLockIntervalCount;
        for (AnypointMQMessage message : messages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(message.getMessageId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(message.getMessageId(), count);
        }
        return this.createSuccessResults(messages);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        ++this.modifyLockIntervalCount;
        ArrayList<AnypointMQMessage> messages = new ArrayList<AnypointMQMessage>();
        for (LockedMessage lockedMessage : lockedMessages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(lockedMessage.getMessage().getMessageId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(lockedMessage.getMessage().getMessageId(), count);
            messages.add(lockedMessage.getMessage());
        }
        return this.createSuccessResults(messages);
    }

    public AnypointMQMessageBuilder newMessageBuilder() {
        return null;
    }

    private CourierObservable<List<MessageIdResult>> createSuccessResults(List<AnypointMQMessage> messages) {
        List results = messages.stream().map(this::createSuccessfulMessageIdResult).collect(Collectors.toList());
        return new DefaultCourierObservable(results);
    }

    private CourierObservable<List<MessageIdResult>> createSuccessResultsWithLocks(List<Lock> locks) {
        List results = locks.stream().map(this::createSuccessfulMessageIdResult).collect(Collectors.toList());
        return new DefaultCourierObservable(results);
    }

    private CourierObservable<MessageIdResult> createSuccessResults(AnypointMQMessage message) {
        return new DefaultCourierObservable((Object)this.createSuccessfulMessageIdResult(message));
    }

    private CourierObservable<MessageIdResult> createSuccessResultsWithLock(Lock lock) {
        return new DefaultCourierObservable((Object)this.createSuccessfulMessageIdResult(lock));
    }

    private MessageIdResult createSuccessfulMessageIdResult(AnypointMQMessage message) {
        return new DefaultMessageIdResult(message.getMessageId(), "successful", "");
    }

    private MessageIdResult createSuccessfulMessageIdResult(Lock lock) {
        return new DefaultMessageIdResult(lock.getMessageId(), "successful", "");
    }

    private MessageIdResult createErrorlMessageIdResult(AnypointMQMessage message) {
        return new DefaultMessageIdResult(message.getMessageId(), "ERROR", "");
    }
}

