/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient;

import com.mulesoft.mq.restclient.AnypointMQClientFactory;
import com.mulesoft.mq.restclient.AnypointMqClient;
import com.mulesoft.mq.restclient.DefaultAnypointMqClient;
import com.mulesoft.mq.restclient.client.ClientUtils;
import com.mulesoft.mq.restclient.client.mq.CourierRestClient;
import com.mulesoft.mq.restclient.client.mq.DefaultCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;

public class DefaultAnypointMQClientFactory
implements AnypointMQClientFactory {
    @Override
    public AnypointMqClient createClient(String courierApiUrl, CourierAuthenticationCredentials authenticationCredentials, String userAgentInfo) {
        ClientUtils.checkArgument(authenticationCredentials instanceof OAuthCredentials, "Invalid credentials.");
        return new DefaultAnypointMqClient(this.createRestClient(courierApiUrl, authenticationCredentials, userAgentInfo));
    }

    private CourierRestClient createRestClient(String courierApiUrl, CourierAuthenticationCredentials authenticationCredentials, String userAgentInfo) {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        AsyncHttpClient asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
        return new DefaultCourierRestClient(asyncHttpClient, courierApiUrl, (OAuthCredentials)authenticationCredentials, userAgentInfo);
    }
}

