/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import rx.Observable;
import rx.Subscriber;

public class DefaultCourierObservable<T>
implements CourierObservable<T> {
    private final Observable<T> rxObservable;

    public DefaultCourierObservable() {
        this(null);
    }

    public DefaultCourierObservable(T value) {
        this(Observable.just(value));
    }

    public DefaultCourierObservable(Observable<T> rxObservable) {
        this.rxObservable = rxObservable.single();
    }

    @Override
    public void subscribe(final CourierObserver<T> observer) {
        this.rxObservable.subscribe(new Subscriber<T>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                observer.onError(e);
            }

            public void onNext(T t) {
                observer.onSuccess(t);
            }
        });
    }

    @Override
    public T getValue() {
        return (T)this.rxObservable.toBlocking().first();
    }

    @Override
    public void fireAndForget() {
        this.rxObservable.subscribe();
    }
}

