/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.DestinationLocation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CourierUrlBuilder {
    private static final String DESTINATION_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s";
    private static final String MESSAGE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages";
    private static final String MESSAGE_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s";
    private static final String LOCK_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/locks";
    private static final String LOCK_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s/locks/%s";
    private final String baseUri;
    private final String authServerBaseUri;

    public CourierUrlBuilder(String baseUri) {
        this.baseUri = baseUri;
        this.authServerBaseUri = baseUri.replaceFirst("/api/v1", "").replaceFirst("mq-[^.]*.", "");
    }

    public String oauth2TokenUrl() {
        return this.authServerBaseUri + "/accounts/oauth2/token";
    }

    public String apiMeUrl() {
        return this.authServerBaseUri + "/accounts/api/me";
    }

    public String messages(DestinationLocation destinationLocation) {
        return String.format(MESSAGE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String message(DestinationLocation destinationLocation, String messageId) {
        return String.format(MESSAGE_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), messageId);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId) {
        String encodedLockId = "ERROR";
        try {
            encodedLockId = URLEncoder.encode(lockId, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return String.format(LOCK_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), messageId, encodedLockId);
    }

    public String locks(DestinationLocation destinationLocation) {
        return String.format(LOCK_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }
}

