/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.internal.TimeAware;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestScheduledExecutorService
implements ScheduledExecutorService,
TimeAware {
    private long now;
    private PriorityQueue<QueuedTask> tasks = new PriorityQueue<QueuedTask>(10, new Comparator<QueuedTask>(){

        @Override
        public int compare(QueuedTask o1, QueuedTask o2) {
            return (int)(o1.nextExecutionTime - o2.nextExecutionTime);
        }
    });

    private void queueTask(Runnable command, long delayMillis, long period) {
        QueuedTask task = new QueuedTask();
        task.command = command;
        task.nextExecutionTime = this.now + delayMillis;
        task.period = period;
        this.tasks.add(task);
    }

    public void timeIs(long now) {
        this.now = now;
        this.executeTasks();
    }

    private void executeTasks() {
        QueuedTask task;
        while ((task = this.tasks.peek()) != null && task.nextExecutionTime <= this.now) {
            this.tasks.poll();
            if (task.period > 0L) {
                this.queueTask(task.command, task.period, task.period);
            }
            task.command.run();
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.queueTask(command, unit.toMillis(delay), 0L);
        return null;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.queueTask(command, unit.toMillis(initialDelay), unit.toMillis(period));
        return null;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public void execute(Runnable command) {
        throw new RuntimeException("Not Supported");
    }

    private class QueuedTask {
        long nextExecutionTime;
        long period;
        Runnable command;

        private QueuedTask() {
        }
    }
}

