/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.client;

import com.mulesoft.mq.restclient.api.AnypointMQClientFactory;
import com.mulesoft.mq.restclient.api.AnypointMqClient;
import com.mulesoft.mq.restclient.api.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.CourierRestClient;
import com.mulesoft.mq.restclient.internal.Utils;
import com.mulesoft.mq.restclient.internal.ahc.DefaultCourierRestClient;
import com.mulesoft.mq.restclient.internal.client.DefaultAnypointMqClient;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;

public class DefaultAnypointMQClientFactory
implements AnypointMQClientFactory {
    @Override
    public AnypointMqClient createClient(String courierApiUrl, CourierAuthenticationCredentials authenticationCredentials, String userAgentInfo) {
        Utils.checkArgument(authenticationCredentials instanceof OAuthCredentials, "Invalid credentials.");
        return new DefaultAnypointMqClient(this.createRestClient(courierApiUrl, authenticationCredentials, userAgentInfo));
    }

    private CourierRestClient createRestClient(String courierApiUrl, CourierAuthenticationCredentials authenticationCredentials, String userAgentInfo) {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        AsyncHttpClient asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
        return new DefaultCourierRestClient(asyncHttpClient, courierApiUrl, (OAuthCredentials)authenticationCredentials, userAgentInfo);
    }
}

