/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClientTestCase;
import com.mulesoft.mq.restclient.client.mq.DefaultCourierRestClient;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultCourierRestClientTestCase
extends AbstractCourierRestClientTestCase {
    private AsyncHttpClient asyncHttpClient;

    @Before
    public void setUpHttpClient() throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    @Override
    protected void createClient() throws Exception {
        this.client = new DefaultCourierRestClient(this.asyncHttpClient, this.apiUrl(), this.oAuthCredential, null);
    }

    @Test
    public void throwExceptionIfDestinationDoesNotExist() throws Exception {
        this.expectedException.expect(ResourceNotFoundException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: RECEIVE MESSAGES"));
        Response receiveResponse = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)receiveResponse.getStatusCode()).thenReturn((Object)404);
        Mockito.when((Object)receiveResponse.getResponseBody()).thenReturn((Object)"");
        Response authResponse = this.getAuthResponseMock();
        this.asyncHttpClient = (AsyncHttpClient)Mockito.spy((Object)this.asyncHttpClient);
        Mockito.when((Object)this.asyncHttpClient.executeRequest((Request)Mockito.any(Request.class), (AsyncHandler)Mockito.any(AsyncCompletionHandler.class))).thenAnswer(invocationOnMock -> {
            Request request = (Request)invocationOnMock.getArguments()[0];
            AsyncCompletionHandler handler = (AsyncCompletionHandler)invocationOnMock.getArguments()[1];
            if (request.getUrl().contains("oauth2/token")) {
                return handler.onCompleted(authResponse);
            }
            return handler.onCompleted(receiveResponse);
        });
        this.setup(0);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }

    private Response getAuthResponseMock() throws IOException {
        Response authResponse = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)authResponse.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)authResponse.getContentType()).thenReturn((Object)"application/json");
        Mockito.when((Object)authResponse.getResponseBody()).thenReturn((Object)"{\"access_token\":\"7db715bb-0553-4c8e-8903-118f93af4318\",\"simple_client\":{\"envId\":\"1c58696d-b6d2-487b-8c88-4abaa03710d8\",\"orgId\":\"33ea21f2-912a-4213-8b49-fe6a111a7cfd\"},\"token_type\":\"bearer\"}");
        return authResponse;
    }
}

