/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq.domain;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.DefaultAnypointMQMessage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnypointMQMessageBuilder {
    private InputStream body;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public AnypointMQMessageBuilder withMessageId(String messageId) {
        this.addHeader("messageId", messageId);
        return this;
    }

    public AnypointMQMessageBuilder withDeliveryDelay(Optional<Long> deliveryDelay) {
        deliveryDelay.ifPresent(delay -> this.addHeader("deliveryDelay", Integer.toString(delay.intValue())));
        return this;
    }

    public AnypointMQMessageBuilder withMessageGroupId(Optional<String> messageGroupId) {
        messageGroupId.ifPresent(groupId -> this.addHeader("messageGroupId", (String)groupId));
        return this;
    }

    public AnypointMQMessageBuilder withLockId(String lockId) {
        this.addHeader("lockId", lockId);
        return this;
    }

    public AnypointMQMessageBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public AnypointMQMessageBuilder withHeaders(Map<String, String> headers) {
        headers.entrySet().stream().forEach(entry -> this.addHeader((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    public AnypointMQMessageBuilder withProperties(Map<String, String> properties) {
        properties.entrySet().stream().forEach(entry -> this.addProperty((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    public AnypointMQMessageBuilder addHeader(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Header name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Header value can not be null");
        this.headers.put(name, value);
        return this;
    }

    public AnypointMQMessageBuilder addProperty(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Property name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Property value can not be null");
        this.properties.put(name, value);
        return this;
    }

    public AnypointMQMessage build() {
        return new DefaultAnypointMQMessage(this.body, this.headers, this.properties);
    }
}

