/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.exception.MQClientConnectionException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.utils.MockCourierServer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import rx.Observable;

public abstract class AbstractCourierRestClientTestCase {
    public int httpPort = new Random().nextInt(30000) + 10000;
    protected MockCourierServer server;
    protected OAuthCredentials oAuthCredential;
    protected AbstractCourierRestClient client;
    protected DestinationLocation mockDestinationLocation = new DestinationLocationBuilder().setOrganizationId("no-org").setEnvironmentId("no-env").setName("some-destination").build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public void setup(int expectedRequests) throws Exception {
        this.setup(expectedRequests, MockCourierServer.OAUTH_CREDENTIALS);
    }

    public void setup(int expectedRequests, OAuthCredentials oAuthCredential) throws Exception {
        this.setup(expectedRequests, oAuthCredential, false, false);
    }

    public void setup(int expectedRequests, boolean failOnServiceRegistryRequest, boolean failOnApiMeRequest) throws Exception {
        this.setup(expectedRequests, MockCourierServer.OAUTH_CREDENTIALS, failOnServiceRegistryRequest, failOnApiMeRequest);
    }

    public void setup(int expectedRequests, OAuthCredentials oAuthCredential, boolean failOnServiceRegistryRequest, boolean failOnApiMeRequest) throws Exception {
        this.oAuthCredential = oAuthCredential;
        this.server = new MockCourierServer(this.httpPort, expectedRequests, failOnServiceRegistryRequest, failOnApiMeRequest);
        this.createClient();
    }

    protected String apiUrl() {
        return "http://localhost:" + this.httpPort + "/api/v1";
    }

    protected abstract void createClient() throws Exception;

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            MockCourierServer serverCopy = this.server;
            this.server = null;
            serverCopy.stop();
        }
        if (this.client != null) {
            this.client.dispose();
        }
    }

    @Test
    public void credentialsOk() throws Exception {
        this.setup(3);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    @Test
    public void wrongCredentials() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: AUTHORIZE AGAINST AUTH SERVER. Cause: Can not login into Authentication Server"));
        this.setup(3, new OAuthCredentials("client-id", "wrong-client-secret"));
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        observableOfMessages.toBlocking().first();
    }

    @Test
    public void whenServiceRegistryEndpointIsDownItShouldRetryAndFail() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: GET SERVICE REGISTRY AGAINST BROKER. Cause: Can not get url from service registry"));
        this.setup(AbstractCourierRestClient.MAX_RETRIES + 1, true, false);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }

    @Test
    public void whenApiMeEndpointIsDownItShouldRetryAndFail() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: GET CLIENT INFORMATION AGAINST AUTH SERVER. Cause: Can not get org and env information from Authentication Server"));
        this.setup(8, false, true);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }

    @Test
    public void send() throws Exception {
        this.setup(4);
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withMessageId("someMessageId");
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody(IOUtils.toInputStream((String)"Some body", (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        messageBuilder.addHeader("Some Header", "Some Header value");
        messageBuilder.addProperty("Some Property", "Some Property value");
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messageBuilder.build());
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
    }

    @Test
    public void sendBatch() throws Exception {
        this.setup(4);
        List<AnypointMQMessage> messages = Arrays.asList(this.createMessage("0"), this.createMessage("1"), this.createMessage("2"));
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messages);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
        }
    }

    @Test
    public void receive() throws Exception {
        this.setup(5);
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        List messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
        AnypointMQMessage message = (AnypointMQMessage)messages.get(0);
        Assert.assertThat((Object)message.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat(message.getHeaders().get("lockId"), (Matcher)Is.is((Object)"someLockId"));
        Assert.assertThat(message.getProperties().get("userDefinedProperty"), (Matcher)Is.is((Object)"User defined stuff"));
        Assert.assertThat(message.getProperties().get("anotherUserDefinedProperty"), (Matcher)Is.is((Object)"Random stuff"));
        Assert.assertThat((Object)message.getBodyAsString(), (Matcher)Is.is((Object)"This is a message payload"));
        observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L);
        messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void ack() throws Exception {
        this.setup(4);
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, new Lock("someMessageId", "someLockId"));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void ackBatch() throws Exception {
        this.setup(4);
        List<Lock> locks = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, locks);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test
    public void nack() throws Exception {
        this.setup(4);
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, new Lock("someMessageId", "someLockId"));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void nackBatch() throws Exception {
        this.setup(4);
        List<Lock> locks = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, locks);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test
    public void modifyTtl() throws Exception {
        this.setup(4);
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, new NewTtl("someMessageId", "someLockId", 1000L));
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
    }

    @Test
    public void modifyTtlBatch() throws Exception {
        this.setup(4);
        List<NewTtl> newTtls = Arrays.asList(this.getNewTtl("0"), this.getNewTtl("1"), this.getNewTtl("2"));
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, newTtls);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Acknowledgement operation successful"));
        }
    }

    @Test(expected=RuntimeException.class)
    public void tooManyRequests() throws Exception {
        this.setup(3);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }

    @Test(expected=RuntimeException.class)
    public void tooFewRequests() throws Exception {
        this.setup(5);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
        this.tearDown();
    }

    @Test
    public void retryOnTokenExpiration() throws Exception {
        this.setup(6);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        this.server.setFailAuthOnNextRequest(true);
        List messages = (List)this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
        Assert.assertThat((Object)messages, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void throwExceptionIfClientAlreadyDisposed() throws Exception {
        this.setup(4);
        this.server.setFailAuthOnNextRequest(false);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
        this.client.dispose();
        try {
            this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
            Assert.fail((String)"Expected a connection exception to be thrown");
        }
        catch (MQClientConnectionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Client has already been disposed"));
        }
    }

    private AnypointMQMessage createMessage(String postfix) {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withMessageId("someMessageId" + (postfix != null ? postfix : ""));
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody(IOUtils.toInputStream((String)"Some body", (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        messageBuilder.addHeader("Some Header", "Some Header value");
        messageBuilder.addProperty("Some Property", "Some Property value");
        return messageBuilder.build();
    }

    private Lock getLockId(String postfix) {
        return new Lock("someMessageId" + postfix, "someLockId" + postfix);
    }

    private NewTtl getNewTtl(String postfix) {
        return new NewTtl("someMessageId" + postfix, "someLockId" + postfix, 1000L);
    }
}

