/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.utils.ClientUtils;
import com.mulesoft.mq.restclient.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MockCourierServer {
    public static final BadRequestHandler BAD_REQUEST_HANDLER = new BadRequestHandler();
    public static final String ACCESS_TOKEN = "dummy-access-token";
    public static final String DESTINATION_NAME = "some-destination";
    private static final String ORGANIZATION_ID = "no-org";
    private static final String ENVIRONMENT_ID = "no-env";
    public static final String CLIENT_ID = "client-id";
    public static final String CLIENT_SECRET = "client-secret";
    public static final OAuthCredentials OAUTH_CREDENTIALS = new OAuthCredentials("client-id", "client-secret");
    public static final String SERVICE_REGISTRY_URL = "GET:/api/v1/serviceRegistry";
    public static final String SERVICE_REGISTRY_RESPONSE_JSON_TEMPLATE = "  {\n    \"authenticationServer\": {\n      \"url\": \"http://localhost:%d/accounts\"\n    }\n  }\n";
    public static final String OAUTH2_TOKEN_URL = "POST:/accounts/oauth2/token";
    public static final String OAUTH2_TOKEN_RESPONSE_JSON = String.format("{\"access_token\": \"%s\", \"token_type\":\"bearer\"}", "dummy-access-token");
    public static final String API_ME_URL = "GET:/accounts/api/me";
    public static final String API_ME_RESPONSE_JSON = String.format("  {\n    \"client\": {\n      \"client_id\": \"%s\",\n      \"name\": \"%s\",\n      \"redirect_uris\": [\n        \"%s\"\n      ],\n      \"grant_types\": [\n        \"client_credentials\",\n        \"authorization_code\"\n      ],\n      \"properties\" : {\n        \"environment\": \"%s\"\n      },\n      \"org_id\": \"%s\"\n    }\n  }\n", "client-id", "clientIdName", "someRedirectUri", "no-env", "no-org");
    public static final String MESSAGE_ID = "someMessageId";
    public static final String LOCK_ID = "someLockId";
    public static final String MESSAGE_PAYLOAD = "This is a message payload";
    public static final String SEND_URL = "PUT:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/someMessageId";
    public static final String SEND_REQUEST = MockCourierServer.messageAsJson("");
    public static final String SEND_RESPONSE_JSON = MockCourierServer.successResponseForMessage("Send", "");
    public static final String SEND_BATCH_URL = "PUT:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages";
    public static final String SEND_BATCH_REQUEST = String.format("[%s,%s,%s]", MockCourierServer.messageAsJson("0"), MockCourierServer.messageAsJson("1"), MockCourierServer.messageAsJson("2"));
    public static final String SEND_BATCH_RESPONSE_JSON = String.format("[\n%s,\n%s,\n%s]", MockCourierServer.successResponseForMessage("Send", "0"), MockCourierServer.successResponseForMessage("Send", "1"), MockCourierServer.successResponseForMessage("Send", "2"));
    public static final String RECEIVE_URL = "GET:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages";
    public static final String RECEIVE_REQUEST = "";
    public static final String RECEIVE_RESPONSE_JSON = String.format("[\n  {\n    \"headers\": {\n      \"messageId\": \"%s\",\n      \"lockId\": \"%s\"\n    },\n    \"properties\": {\n      \"anotherUserDefinedProperty\": \"Random stuff\",\n      \"userDefinedProperty\": \"User defined stuff\"\n    },\n    \"body\": \"%s\"\n  }\n]", "someMessageId", "someLockId", "This is a message payload");
    public static final String ACK_URL = "DELETE:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/someMessageId";
    public static final String ACK_REQUEST = "{\"lockId\":\"someLockId\"}";
    public static final String ACK_RESPONSE_JSON = MockCourierServer.successResponseForMessage("Acknowledgement", "");
    public static final String ACK_BATCH_URL = "DELETE:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages";
    public static final String ACK_BATCH_REQUEST = String.format("[%s,%s,%s]", MockCourierServer.ackRequestForMessage("0"), MockCourierServer.ackRequestForMessage("1"), MockCourierServer.ackRequestForMessage("2"));
    public static final String ACK_BATCH_RESPONSE_JSON = String.format("[\n%s,\n%s,\n%s]", MockCourierServer.successResponseForMessage("Acknowledgement", "0"), MockCourierServer.successResponseForMessage("Acknowledgement", "1"), MockCourierServer.successResponseForMessage("Acknowledgement", "2"));
    public static final String NACK_URL = "DELETE:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/someMessageId/locks/someLockId";
    public static final String NACK_REQUEST = "";
    public static final String NACK_RESPONSE_JSON = ACK_RESPONSE_JSON;
    public static final String NACK_BATCH_URL = "DELETE:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/locks";
    public static final String NACK_BATCH_REQUEST = ACK_BATCH_REQUEST;
    public static final String NACK_BATCH_RESPONSE_JSON = ACK_BATCH_RESPONSE_JSON;
    public static final String NEW_TTL_URL = "PATCH:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/someMessageId/locks/someLockId";
    public static final String NEW_TTL_REQUEST = "{\"ttl\":\"1000\"}";
    public static final String NEW_TTL_RESPONSE_JSON = MockCourierServer.successResponseForMessage("Acknowledgement", "");
    public static final String NEW_TTL_BATCH_URL = "PATCH:/api/v1/organizations/no-org/environments/no-env/destinations/some-destination/messages/locks";
    public static final String NEW_TTL_BATCH_REQUEST = "[{\"ttl\":1000,\"messageId\":\"someMessageId0\",\"lockId\":\"someLockId0\"},{\"ttl\":1000,\"messageId\":\"someMessageId1\",\"lockId\":\"someLockId1\"},{\"ttl\":1000,\"messageId\":\"someMessageId2\",\"lockId\":\"someLockId2\"}]";
    public static final String NEW_TTL_BATCH_RESPONSE_JSON = ACK_BATCH_RESPONSE_JSON;
    private Server server;
    private CountDownLatch latch;
    private AtomicBoolean failAuthOnNextRequest = new AtomicBoolean(false);
    private AtomicBoolean hasCustomReceiveResponse = new AtomicBoolean(false);
    private int customReceiveResponseStatusCode;
    private String customReceiveResponseBody;
    private boolean failOnServiceRegistryRequest = false;
    private boolean failOnApiMeRequest = false;

    private static String messageAsJson(String suffix) {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withMessageId(MESSAGE_ID + suffix);
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody(IOUtils.toInputStream((String)"Some body", (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        messageBuilder.addHeader("Some Header", (Object)"Some Header value");
        messageBuilder.addProperty("Some Property", (Object)"Some Property value");
        return JsonUtils.toJson((Object)messageBuilder.build());
    }

    private static String successResponseForMessage(String op, String suffix) {
        return String.format("{\n  \"messageId\": \"%s\",\n  \"status\": \"successful\",\n  \"statusMessage\": \"%s operation successful\"\n}", MESSAGE_ID + suffix, op);
    }

    private static String ackRequestForMessage(String suffix) {
        return String.format("{\"messageId\":\"someMessageId%s\",\"lockId\":\"someLockId%s\"}", suffix, suffix);
    }

    public MockCourierServer(int port, int expectedRequests, boolean failOnServiceRegistryRequest, boolean failOnApiMeRequest) throws Exception {
        this.latch = new CountDownLatch(expectedRequests);
        this.server = new Server(port);
        this.server.setHandler((Handler)new MockHandler(port));
        this.server.start();
        this.failOnServiceRegistryRequest = failOnServiceRegistryRequest;
        this.failOnApiMeRequest = failOnApiMeRequest;
    }

    public void stop() throws Exception {
        this.server.stop();
        if (this.latch.getCount() > 0L) {
            throw new RuntimeException("Too few requests received. Expected " + this.latch.getCount() + " more request(s).");
        }
    }

    public void setFailAuthOnNextRequest(boolean failAuthOnNextRequest) {
        this.failAuthOnNextRequest.set(failAuthOnNextRequest);
    }

    public void setCustomReceiveResponse(int statusCode, String body) {
        this.hasCustomReceiveResponse.set(true);
        this.customReceiveResponseStatusCode = statusCode;
        this.customReceiveResponseBody = body;
    }

    static class BadRequestHandler
    extends CustomHandler {
        public BadRequestHandler() {
            super(400, "<h1>Bad Request</h1>");
        }
    }

    class ReceiveHandler
    extends SecuredHandler {
        public ReceiveHandler() {
            super("", RECEIVE_RESPONSE_JSON);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            if (context.hasCustomReceiveResponse) {
                context.status = MockCourierServer.this.customReceiveResponseStatusCode;
                context.body = MockCourierServer.this.customReceiveResponseBody;
            } else {
                String[] pollingTimeParameter = (String[])request.getParameterMap().get("pollingTime");
                if (pollingTimeParameter != null && pollingTimeParameter.length == 1 && pollingTimeParameter[0].equals("1234")) {
                    try {
                        long t0 = System.currentTimeMillis();
                        while (System.currentTimeMillis() - t0 < 20000L && context.server.isRunning()) {
                            Thread.sleep(200L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            super.handle(request, response, context);
        }
    }

    static class SecuredHandler
    extends CustomHandler {
        private final String expectedRequest;

        public SecuredHandler(String expectedRequest, String body) {
            super(200, body);
            this.expectedRequest = expectedRequest;
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            String receivedRequest;
            boolean hasAccessToken = "Bearer dummy-access-token".equals(request.getHeader("Authorization"));
            if (context.failAuth || !hasAccessToken) {
                context.status = 401;
                context.body = "<h1>Unauthorized</h1>";
            }
            if (this.expectedRequest != null && !this.expectedRequest.equals(receivedRequest = this.getContent(request))) {
                throw new RuntimeException(String.format("Unexpected request received.\nExpected: %s\nReceived: %s", this.expectedRequest, receivedRequest));
            }
            super.handle(request, response, context);
        }

        private String getContent(HttpServletRequest request) {
            try {
                return ClientUtils.toString((InputStream)request.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ApiMeHandler
    extends CustomHandler {
        public ApiMeHandler() {
            super(200, API_ME_RESPONSE_JSON);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            if (MockCourierServer.this.failOnApiMeRequest) {
                context.status = 500;
                context.body = "Internal server error";
            }
            super.handle(request, response, context);
        }
    }

    class ServiceRegistryHandler
    extends CustomHandler {
        public ServiceRegistryHandler(int serverPort) {
            super(200, String.format(MockCourierServer.SERVICE_REGISTRY_RESPONSE_JSON_TEMPLATE, serverPort));
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            if (MockCourierServer.this.failOnServiceRegistryRequest) {
                context.status = 500;
                context.body = "Internal server error";
            }
            super.handle(request, response, context);
        }
    }

    static class Oauth2TokenHandler
    extends CustomHandler {
        public Oauth2TokenHandler() {
            super(200, OAUTH2_TOKEN_RESPONSE_JSON);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            boolean authOk;
            boolean bl = authOk = MockCourierServer.CLIENT_ID.equals(request.getParameter("client_id")) && MockCourierServer.CLIENT_SECRET.equals(request.getParameter("client_secret"));
            if (!authOk) {
                context.status = 401;
                context.body = "<h1>Unauthorized</h1>";
            }
            super.handle(request, response, context);
        }
    }

    static class CustomHandler {
        private final int defaultStatusResponse;
        private final String defaultBodyResponse;

        public CustomHandler(int defaultStatusResponse, String defaultBodyResponse) {
            this.defaultStatusResponse = defaultStatusResponse;
            this.defaultBodyResponse = defaultBodyResponse;
        }

        public HandlerContext createHandlerContext() {
            return new HandlerContext(this.defaultStatusResponse, this.defaultBodyResponse);
        }

        public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
            Assert.assertThat((Object)request.getHeader("User-Agent"), (Matcher)Matchers.is((Object)("Mule Anypoint MQ/" + ClientUtils.getUserAgentVersion())));
            response.setContentType("text/html");
            response.setStatus(context.status);
            try {
                response.getWriter().print(context.body);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class HandlerContext {
        private int status = 200;
        private String body;
        private boolean failAuth = false;
        private boolean hasCustomReceiveResponse = false;
        private Server server;

        public HandlerContext(int status, String body) {
            this.status = status;
            this.body = body;
        }
    }

    class MockHandler
    extends AbstractHandler {
        Map<String, CustomHandler> responseMap = new HashMap<String, CustomHandler>();

        public MockHandler(int serverPort) {
            this.responseMap.put(MockCourierServer.OAUTH2_TOKEN_URL, new Oauth2TokenHandler());
            this.responseMap.put(MockCourierServer.API_ME_URL, new ApiMeHandler());
            this.responseMap.put(MockCourierServer.SERVICE_REGISTRY_URL, new ServiceRegistryHandler(serverPort));
            this.responseMap.put(MockCourierServer.RECEIVE_URL, new ReceiveHandler());
            this.responseMap.put(MockCourierServer.SEND_URL, new SecuredHandler(SEND_REQUEST, SEND_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.SEND_BATCH_URL, new SecuredHandler(SEND_BATCH_REQUEST, SEND_BATCH_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.ACK_URL, new SecuredHandler(MockCourierServer.ACK_REQUEST, ACK_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.ACK_BATCH_URL, new SecuredHandler(ACK_BATCH_REQUEST, ACK_BATCH_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.NACK_URL, new SecuredHandler("", NACK_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.NACK_BATCH_URL, new SecuredHandler(NACK_BATCH_REQUEST, NACK_BATCH_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.NEW_TTL_URL, new SecuredHandler(MockCourierServer.NEW_TTL_REQUEST, NEW_TTL_RESPONSE_JSON));
            this.responseMap.put(MockCourierServer.NEW_TTL_BATCH_URL, new SecuredHandler(MockCourierServer.NEW_TTL_BATCH_REQUEST, NEW_TTL_BATCH_RESPONSE_JSON));
        }

        public synchronized void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException {
            if (MockCourierServer.this.latch.getCount() <= 0L) {
                throw new ServletException("Too many request received");
            }
            String key = baseRequest.getMethod() + ":" + target;
            CustomHandler customHandler = this.responseMap.get(key);
            HandlerContext context = customHandler.createHandlerContext();
            context.failAuth = MockCourierServer.this.failAuthOnNextRequest.getAndSet(false);
            context.hasCustomReceiveResponse = MockCourierServer.this.hasCustomReceiveResponse.getAndSet(false);
            context.server = MockCourierServer.this.server;
            if (customHandler != null) {
                customHandler.handle(request, response, context);
            } else {
                BAD_REQUEST_HANDLER.handle(request, response, context);
            }
            baseRequest.setHandled(true);
            MockCourierServer.this.latch.countDown();
        }
    }
}

