/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq.domain;

import com.google.common.base.Preconditions;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.DefaultAnypointMQMessage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnypointMQMessageBuilder {
    private InputStream body;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public AnypointMQMessageBuilder withMessageId(String messageId) {
        this.addHeader("messageId", messageId);
        return this;
    }

    public AnypointMQMessageBuilder withDeliveryDelay(Optional<Long> deliveryDelay) {
        deliveryDelay.ifPresent(delay -> this.addHeader("deliveryDelay", Integer.toString(delay.intValue())));
        return this;
    }

    public AnypointMQMessageBuilder withMessageGroupId(Optional<String> messageGroupId) {
        messageGroupId.ifPresent(groupId -> this.addHeader("messageGroupId", groupId));
        return this;
    }

    public AnypointMQMessageBuilder withLockId(String lockId) {
        this.addHeader("lockId", lockId);
        return this;
    }

    public AnypointMQMessageBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public AnypointMQMessageBuilder withHeaders(Map<String, Object> headers) {
        headers.entrySet().stream().forEach(entry -> this.addHeader((String)entry.getKey(), entry.getValue()));
        return this;
    }

    public AnypointMQMessageBuilder withProperties(Map<String, Object> properties) {
        properties.entrySet().stream().forEach(entry -> this.addProperty((String)entry.getKey(), entry.getValue()));
        return this;
    }

    public AnypointMQMessageBuilder addHeader(String name, Object value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Header name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Header value can not be null");
        Preconditions.checkArgument((value instanceof String || value instanceof Number ? 1 : 0) != 0, (Object)"Header value accept only string or number as values");
        this.headers.put(name, value);
        return this;
    }

    public AnypointMQMessageBuilder addProperty(String name, Object value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Property name can not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Property value can not be null");
        Preconditions.checkArgument((value instanceof String || value instanceof Number ? 1 : 0) != 0, (Object)"Property value accept only string or number as values");
        this.properties.put(name, value);
        return this;
    }

    public AnypointMQMessage build() {
        return new DefaultAnypointMQMessage(this.body, this.headers, this.properties);
    }
}

