/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClientTestCase;
import com.mulesoft.mq.restclient.client.mq.DefaultCourierRestClient;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.utils.MockCourierServer;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultCourierRestClientTestCase
extends AbstractCourierRestClientTestCase {
    private AsyncHttpClient asyncHttpClient;

    @Before
    public void setUpHttpClient() throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    @Override
    protected void createClient() throws Exception {
        this.client = new DefaultCourierRestClient(this.asyncHttpClient, this.apiUrl4x(), this.oAuthCredential, null);
        this.client.init();
    }

    @Test
    public void createClientWithOrgUrlShouldPass() throws Exception {
        this.oAuthCredential = MockCourierServer.OAUTH_CREDENTIALS;
        MockCourierServer sv = new MockCourierServer(this.httpPort, 3, false, false);
        String inputUrl = this.apiUrl3x() + "/organizations/org-id/environments/env-id";
        DefaultCourierRestClient cl = new DefaultCourierRestClient(this.asyncHttpClient, inputUrl, this.oAuthCredential, null);
        Assert.assertTrue((boolean)cl.getBaseUri().equals(this.apiUrl3x()));
        cl.init();
        Assert.assertTrue((boolean)cl.getDefaultOrganizationId().equals("org-id"));
        Assert.assertTrue((boolean)cl.getDefaultEnvironmentId().equals("env-id"));
    }

    @Test
    public void createClientWithApiUrlNoOrgShouldFail() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Invalid api url provided"));
        this.oAuthCredential = MockCourierServer.OAUTH_CREDENTIALS;
        MockCourierServer sv = new MockCourierServer(this.httpPort, 3, false, false);
        String inputUrl = this.apiUrl3x() + "/blahblahblah";
        DefaultCourierRestClient cl = new DefaultCourierRestClient(this.asyncHttpClient, inputUrl, this.oAuthCredential, null);
    }

    @Test
    public void createClientWithIncorrectApiUrlNoEnvShouldThrowException() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Invalid api url provided"));
        this.oAuthCredential = MockCourierServer.OAUTH_CREDENTIALS;
        MockCourierServer sv = new MockCourierServer(this.httpPort, 3, false, false);
        String inputUrl = this.apiUrl3x() + "/organizations/org-id";
        DefaultCourierRestClient cl = new DefaultCourierRestClient(this.asyncHttpClient, inputUrl, this.oAuthCredential, null);
        Assert.assertTrue((boolean)cl.getBaseUri().equals(this.apiUrl3x()));
        cl.init();
    }

    @Test
    public void throwExceptionIfDestinationDoesNotExist() throws Exception {
        this.setup(3);
        this.expectedException.expect(ResourceNotFoundException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: RECEIVE MESSAGES"));
        this.server.setCustomReceiveResponse(404, "");
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L).toBlocking().first();
    }
}

