/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.circuit.breaker;

import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.circuit.DefaultCircuitBreaker;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class CircuitsBreakerTestCase {
    private static final long LONG_TRIP_TIMEOUT = 60000L;
    private static final long SHORT_TRIP_TIMEOUT = 1000L;
    private static final long TRIP_VALIDATION_EXTRA_WAIT = 100L;
    private static final String ANY_ERROR_WHITELIST = null;
    private static final String MY_CIRCUIT = "myCircuit";
    private static final String UNKNOWN_ERROR = "UNKNOWN";
    private static final String EXPECTED_ERROR = "OS:STORE";

    @Test
    public void countsErrorToOpen() {
        int errorsThreshold = 5;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 5, 60000L, TimeUnit.MILLISECONDS);
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
        this.repeatError((MQCircuitBreaker)circuitBreaker, 4, UNKNOWN_ERROR);
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void tripTimeoutEvictMovesToHalfOpen() throws InterruptedException {
        boolean errorsThreshold = true;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 1, 1000L, TimeUnit.MILLISECONDS);
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
        Thread.sleep(100L);
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void failureDoesNotResetTimerOnOpen() throws InterruptedException {
        int errorsThreshold = 5;
        int tripTimeout = 1000;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 5, 1000L, TimeUnit.MILLISECONDS);
        this.forceOpenCircuit((MQCircuitBreaker)circuitBreaker, 5, UNKNOWN_ERROR);
        Thread.sleep(500L);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
        Thread.sleep(600L);
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void successDoesNotCloseCircuitWhileOpen() throws InterruptedException {
        int errorsThreshold = 5;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 5, 1000L, TimeUnit.MILLISECONDS);
        this.forceOpenCircuit((MQCircuitBreaker)circuitBreaker, 5, UNKNOWN_ERROR);
        circuitBreaker.onSuccess();
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onSuccess();
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void halfOpenGoesToOpenOnFailure() throws InterruptedException {
        int errorsThreshold = 2;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 2, 1000L, TimeUnit.MILLISECONDS);
        this.forceOpenCircuit((MQCircuitBreaker)circuitBreaker, 2, UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertOpen((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void halfOpenGoesToClosedOnSuccess() throws InterruptedException {
        int errorsThreshold = 2;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 2, 1000L, TimeUnit.MILLISECONDS);
        this.forceOpenCircuit((MQCircuitBreaker)circuitBreaker, 2, UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onSuccess();
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
    }

    @Test
    public void errorCounterIsResetOnSuccess() throws InterruptedException {
        int errorsThreshold = 3;
        DefaultCircuitBreaker circuitBreaker = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 3, 1000L, TimeUnit.MILLISECONDS);
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
        this.repeatError((MQCircuitBreaker)circuitBreaker, 2, UNKNOWN_ERROR);
        circuitBreaker.onSuccess();
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.forceOpenCircuit((MQCircuitBreaker)circuitBreaker, 2, UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        circuitBreaker.onSuccess();
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        circuitBreaker.onFailure(UNKNOWN_ERROR);
        this.assertClosed((MQCircuitBreaker)circuitBreaker);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidErrorThreshold() {
        boolean errorsThreshold = false;
        new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, 0, 60000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void errorMatcherFiltersErrors() {
        int errorsThreshold = 4;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, EXPECTED_ERROR, errorsThreshold, 60000L, TimeUnit.MILLISECONDS);
        this.assertClosed((MQCircuitBreaker)cb);
        this.repeatError((MQCircuitBreaker)cb, 10, UNKNOWN_ERROR);
        this.assertClosed((MQCircuitBreaker)cb);
        this.repeatError((MQCircuitBreaker)cb, 2, EXPECTED_ERROR);
        this.assertClosed((MQCircuitBreaker)cb);
        this.repeatError((MQCircuitBreaker)cb, 10, UNKNOWN_ERROR);
        this.forceOpenCircuit((MQCircuitBreaker)cb, 2, EXPECTED_ERROR);
    }

    @Test
    public void lockAcquiredOnlyInHalfOpenState() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testThatAwaitReturnedTrueSinceLockWasReleased() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        TimerTask unlock = new TimerTask((MQCircuitBreaker)cb){
            final /* synthetic */ MQCircuitBreaker val$cb;
            {
                this.val$cb = mQCircuitBreaker;
            }

            @Override
            public void run() {
                this.val$cb.releaseCircuitLock();
            }
        };
        new Timer().schedule(unlock, 1000L);
        boolean result = cb.awaitCircuitLock(2000);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        this.assertHalfOpen((MQCircuitBreaker)cb);
    }

    @Test
    public void testThatAwaitReturnedFalseSinceLockWasNotReleased() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        boolean result = cb.awaitCircuitLock(2000);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
        this.assertHalfOpen((MQCircuitBreaker)cb);
    }

    @Test
    public void lockAcquiredOnlyOnceUntilSuccess() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onSuccess();
        this.assertClosed((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void lockAcquiredAndReturnedIsValidAgain() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)cb.releaseCircuitLock(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)cb.releaseCircuitLock(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void lockAcquiredOnlyOnceUntilFailure() throws InterruptedException {
        int errorsThreshold = 1;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, 1000L, TimeUnit.MILLISECONDS);
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        cb.onFailure(UNKNOWN_ERROR);
        this.waitShortTripTimeout();
        this.assertHalfOpen((MQCircuitBreaker)cb);
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)cb.acquireCircuitLock(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void tripTimeoutHonouredFromOpenToHalfOpen() throws InterruptedException {
        int errorsThreshold = 1;
        long tripTimeOutMillis = 1000L;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, tripTimeOutMillis, TimeUnit.MILLISECONDS);
        cb.onFailure(UNKNOWN_ERROR);
        Thread.sleep(tripTimeOutMillis / 2L);
        this.assertOpen((MQCircuitBreaker)cb);
        Thread.sleep(tripTimeOutMillis / 4L);
        this.assertOpen((MQCircuitBreaker)cb);
        Thread.sleep(tripTimeOutMillis / 2L);
        this.assertHalfOpen((MQCircuitBreaker)cb);
    }

    @Test
    public void tripTimeoutIsConverted() throws InterruptedException {
        int errorsThreshold = 1;
        long tripTimeOutSeconds = 1L;
        DefaultCircuitBreaker cb = new DefaultCircuitBreaker(MY_CIRCUIT, ANY_ERROR_WHITELIST, errorsThreshold, tripTimeOutSeconds, TimeUnit.SECONDS);
        cb.onFailure(UNKNOWN_ERROR);
        Thread.sleep(500L);
        this.assertOpen((MQCircuitBreaker)cb);
        Thread.sleep(300L);
        this.assertOpen((MQCircuitBreaker)cb);
        Thread.sleep(500L);
        this.assertHalfOpen((MQCircuitBreaker)cb);
    }

    private void waitShortTripTimeout() throws InterruptedException {
        Thread.sleep(1100L);
    }

    private void assertClosed(MQCircuitBreaker circuitBreaker) {
        MatcherAssert.assertThat((String)"Expected CLOSED but was OPEN", (Object)circuitBreaker.isOpen(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Expected CLOSED but was HALF_OPEN", (Object)circuitBreaker.isHalfOpen(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)("Expected CLOSED but was " + circuitBreaker.getState().name()), (Object)circuitBreaker.isClosed(), (Matcher)Is.is((Object)true));
    }

    private void assertOpen(MQCircuitBreaker circuitBreaker) {
        MatcherAssert.assertThat((String)"Expected OPEN but was CLOSED", (Object)circuitBreaker.isClosed(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Expected OPEN but was HALF_OPEN", (Object)circuitBreaker.isHalfOpen(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)("Expected OPEN but was " + circuitBreaker.getState().name()), (Object)circuitBreaker.isOpen(), (Matcher)Is.is((Object)true));
    }

    private void assertHalfOpen(MQCircuitBreaker circuitBreaker) {
        MatcherAssert.assertThat((String)"Expected HALF_OPEN but was CLOSED", (Object)circuitBreaker.isClosed(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Expected HALF_OPEN but was OPEN", (Object)circuitBreaker.isOpen(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)("Expected HALF_OPEN but was " + circuitBreaker.getState().name()), (Object)circuitBreaker.isHalfOpen(), (Matcher)Is.is((Object)true));
    }

    private void forceOpenCircuit(MQCircuitBreaker circuitBreaker, int errorThreshold, String unknownError) {
        this.assertClosed(circuitBreaker);
        this.repeatError(circuitBreaker, errorThreshold, unknownError);
        this.assertOpen(circuitBreaker);
    }

    private void repeatError(MQCircuitBreaker cb, int times, String error) {
        for (int i = 0; i < times; ++i) {
            cb.onFailure(error);
        }
    }
}

