/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.circuit.breaker;

import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.circuit.NoOpCircuitBreaker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

public class NoOpCircuitBreakerTestCase {
    private NoOpCircuitBreaker noOpCircuitBreaker;

    @Before
    public void setUp() throws Exception {
        this.noOpCircuitBreaker = new NoOpCircuitBreaker();
    }

    @Test
    public void lockIsNeverAcquired() {
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.releaseCircuitLock(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.releaseCircuitLock(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void neverWaitsForLock() throws InterruptedException {
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.acquireCircuitLock(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.awaitCircuitLock(100), (Matcher)Is.is((Object)true));
    }

    @Test
    public void stateIsAlwaysClosed() {
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.getState(), (Matcher)Is.is((Object)MQCircuitBreaker.CircuitState.CLOSED));
        for (int i = 0; i < 10; ++i) {
            MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.onFailure("TIMEOUT"), (Matcher)Is.is((Object)MQCircuitBreaker.CircuitState.CLOSED));
        }
        MatcherAssert.assertThat((Object)this.noOpCircuitBreaker.getState(), (Matcher)Is.is((Object)MQCircuitBreaker.CircuitState.CLOSED));
    }
}

