/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.internal.DestinationLocation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CourierUrlBuilder {
    private static final String DESTINATION_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s";
    private static final String MESSAGE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages";
    private static final String MESSAGE_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s";
    private static final String LOCK_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/locks";
    private static final String LOCK_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s/locks/%s";
    private final String baseUri;

    public CourierUrlBuilder(String baseUri) {
        this.baseUri = baseUri;
    }

    public String serviceRegistryUrl() {
        return this.baseUri + "/serviceRegistry";
    }

    public String encode(String idToBeEncoded, String encodingType) throws UnsupportedEncodingException {
        return URLEncoder.encode(idToBeEncoded, encodingType);
    }

    public String messages(DestinationLocation destinationLocation) {
        return String.format(MESSAGE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String message(DestinationLocation destinationLocation, String messageId) {
        String encodedMessageId;
        try {
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedMessageId = "someMessageIdValue";
        }
        return String.format(MESSAGE_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId) {
        String encodedMessageId;
        String encodedLockId;
        try {
            encodedLockId = this.encode(lockId, "UTF-8");
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedLockId = "ERROR";
            encodedMessageId = "someMessageIdValue";
        }
        return String.format(LOCK_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId, encodedLockId);
    }

    public String locks(DestinationLocation destinationLocation) {
        return String.format(LOCK_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }
}

