/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.impl;

import com.mulesoft.mq.restclient.client.mq.CourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.impl.LockedMessage;
import java.util.ArrayList;
import java.util.List;

public class DefaultDestination
implements Destination {
    private final CourierRestClient client;
    private final DestinationLocation destinationLocation;

    public DefaultDestination(CourierRestClient client, DestinationLocation destinationLocation) {
        this.client = client;
        this.destinationLocation = destinationLocation;
    }

    @Override
    public String getName() {
        return this.destinationLocation.getName();
    }

    public DefaultCourierObservable<MessageIdResult> send(AnypointMQMessage message) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.send(this.destinationLocation, message));
    }

    public DefaultCourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.send(this.destinationLocation, messages));
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive() {
        return this.receive(1, 0L, 120000L);
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl) {
        return new DefaultCourierObservable<List<AnypointMQMessage>>(this.client.receive(this.destinationLocation, batchSize, pollingTime, lockTtl));
    }

    public DefaultCourierObservable<List<MessageIdResult>> ack(List<Lock> locks) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.ack(this.destinationLocation, locks));
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.ack(this.destinationLocation, lock));
    }

    public DefaultCourierObservable<List<MessageIdResult>> nack(List<Lock> locks) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.nack(this.destinationLocation, locks));
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.nack(this.destinationLocation, lock));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (AnypointMQMessage message : messages) {
            newTtls.add(new NewTtl(message.getMessageId(), message.getLockId(), lockInterval));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (LockedMessage lockedMessage : lockedMessages) {
            newTtls.add(new NewTtl(lockedMessage.getMessage().getMessageId(), lockedMessage.getMessage().getLockId(), lockedMessage.getLockInterval()));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    @Override
    public AnypointMQMessageBuilder newMessageBuilder() {
        return new AnypointMQMessageBuilder();
    }
}

