/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.Lock;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.api.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.api.exception.RestException;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Response;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.utils.TestDestination;
import com.mulesoft.mq.restclient.utils.TestMessage;
import com.mulesoft.mq.restclient.utils.TestTimeSupplier;
import com.mulesoft.mq.restclient.utils.TestUtils;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScheduledPrefetcherTestCase {
    private static final int POLLING_TIME = 250;
    private static final int BATCH_SIZE = 5;
    private static final long START_TIME = 0L;
    private static final int SCHEDULE_FIXED_FREQUENCY = 500;
    private static final String ID_ONE = "id-1";
    private static final String ID_TWO = "id-2";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String ID_THREE = "id-3";
    private static final String THREE = "3";
    private static final int DEFAULT_CIRCUIT_TTL = 480000;
    @Mock
    private MQCircuitBreaker circuitBreakerMock;
    private final ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException("Destination not found", (Throwable)Mockito.mock(RestException.class), (Response)Mockito.mock(Response.class));
    private TestDestination destination;
    private ScheduledPrefetcher prefetcher;
    private ScheduledExecutorService testCallbackExecutor;

    @Before
    public void setup() {
        this.testCallbackExecutor = Executors.newScheduledThreadPool(4);
        this.destination = (TestDestination)Mockito.spy((Object)new TestDestination(new TestTimeSupplier(0L)));
        this.setCircuitState(MQCircuitBreaker.CircuitState.CLOSED);
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, null, this.circuitBreakerMock, 480000);
    }

    @After
    public void tearDown() {
        this.prefetcher.stop();
    }

    @Test
    public void useMaxBatchSizeWhenBufferIsLarger() {
        int maxLocalMessages = 30;
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, maxLocalMessages, 120000L, 500L, null, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.timeout((long)1000L))).receive(10, 20000L, 120000L);
    }

    @Test
    public void useBufferSizeWhenSmallerThanMaxBatchSize() {
        int maxLocalMessages = 5;
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, maxLocalMessages, 120000L, 500L, null, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.timeout((long)1000L))).receive(maxLocalMessages, 20000L, 120000L);
    }

    @Test
    public void singleInFlightRequestsOnSmallLocalBuffer() {
        this.setDestinationCallBackOnSubscribe(o -> {});
        int maxLocalMessages = 5;
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, maxLocalMessages, 120000L, 500L, null, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)2000))).receive(maxLocalMessages, 20000L, 120000L);
    }

    @Test
    public void maxInFlightRequestsOnLargeLocalBuffer() {
        this.setDestinationCallBackOnSubscribe(o -> {});
        int maxLocalMessages = 50;
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, maxLocalMessages, 120000L, 500L, null, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)3000).times(3))).receive(10, 20000L, 120000L);
    }

    @Test
    public void pollSkippedWhenInFlightRequestsLimitReached() {
        this.setDestinationCallBackOnSubscribe(o -> {});
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)2500))).receive(5, 20000L, 120000L);
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.atMost((int)3))).acquireCircuitLock();
    }

    @Test
    public void inFlightRequestsReleasedOnSuccess() {
        this.setDestinationCallBackOnSubscribe(o -> o.onSuccess((Object)ImmutableList.of((Object)this.createTestMessage(ONE))));
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.timeout((long)2500L).atLeast(4))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
    }

    @Test
    public void inFlightRequestsReleasedOnError() {
        this.setDestinationCallBackOnSubscribe(o -> o.onError((Throwable)new RuntimeException()));
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.timeout((long)2500L).atLeast(4))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
    }

    @Test
    public void prefetcherStoppedWhileRequestInFlightDoesNotRetry() {
        this.setDestinationCallBackOnSubscribe(o -> {
            this.prefetcher.stop();
            o.onError((Throwable)new RuntimeException());
        });
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1500))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock)).releaseCircuitLock();
    }

    @Test
    public void prefetcherStoppedOnResourceNotFound() {
        this.prefetcher = (ScheduledPrefetcher)Mockito.spy((Object)this.prefetcher);
        this.setDestinationCallBackOnSubscribe(o -> o.onError((Throwable)new ResourceNotFoundException("Destination not found", null, null)));
        this.prefetcher.start();
        ((ScheduledPrefetcher)Mockito.verify((Object)this.prefetcher, (VerificationMode)Mockito.timeout((long)1500L))).stop();
    }

    @Test
    public void retrieveMessagesOnStart() {
        this.destination.send(this.createTestMessage(ONE));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)0));
        this.prefetcher.start();
        TestUtils.probe(600L, 200L, () -> MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void retrieveMessagePeriodicallyOnEmptyQueue() throws Exception {
        Destination destinationMock = (Destination)Mockito.mock(Destination.class);
        Mockito.when((Object)destinationMock.receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong())).thenAnswer(invocation -> new CourierObservable<List<AnypointMQMessage>>(){

            public void subscribe(CourierObserver<List<AnypointMQMessage>> observer) {
                ScheduledPrefetcherTestCase.this.testCallbackExecutor.submit(() -> observer.onSuccess(Collections.emptyList()));
            }

            public List<AnypointMQMessage> getValue() {
                return null;
            }

            public void fireAndForget() {
            }
        });
        this.prefetcher = new ScheduledPrefetcher(destinationMock, 5, 120000L, 500L, null, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.timeout((long)500L))).receive(5, 20000L, 120000L);
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.after((int)250))).receive(5, 20000L, 120000L);
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.timeout((long)500L).times(2))).receive(5, 20000L, 120000L);
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.after((int)250).times(2))).receive(5, 20000L, 120000L);
    }

    @Test
    public void prefetcherActsLikeAQueue() {
        this.destination.send(this.createTestMessage(ONE));
        this.destination.send(this.createTestMessage(TWO));
        this.destination.send(this.createTestMessage(THREE));
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)5000L).times(3))).add((AnypointMQMessage)org.mockito.Matchers.any(AnypointMQMessage.class), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_ONE));
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_TWO));
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_THREE));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void checkMessageExpiredOnCall() {
        AnypointMQMessage message = this.createTestMessage(ONE);
        this.destination.send(message);
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMQMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_ONE));
        ((MessagePreserver)Mockito.verify((Object)preserverMock)).isExpired(ID_ONE);
    }

    @Test
    public void skipExpiredMessage() {
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        Mockito.when((Object)preserverMock.isExpired((String)Mockito.eq((Object)ID_ONE))).thenReturn((Object)true);
        Mockito.when((Object)preserverMock.isExpired((String)Mockito.eq((Object)ID_TWO))).thenReturn((Object)false);
        AnypointMQMessage firstMessage = this.createTestMessage(ONE);
        AnypointMQMessage secondMessage = this.createTestMessage(TWO);
        this.destination.send(firstMessage);
        this.destination.send(secondMessage);
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)5000L).times(2))).add((AnypointMQMessage)org.mockito.Matchers.any(AnypointMQMessage.class), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_TWO));
        ((MessagePreserver)Mockito.verify((Object)preserverMock)).isExpired(ID_ONE);
        ((MessagePreserver)Mockito.verify((Object)preserverMock)).isExpired(ID_TWO);
    }

    @Test
    public void removeMessageOnCall() {
        AnypointMQMessage message = this.createTestMessage(ONE);
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.destination.send(message);
        this.prefetcher.start();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMQMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
        MatcherAssert.assertThat((Object)((AnypointMQMessage)this.prefetcher.get().toBlocking().first()).getMessageId(), (Matcher)Matchers.is((Object)ID_ONE));
        ((MessagePreserver)Mockito.verify((Object)preserverMock)).remove(ID_ONE);
    }

    @Test
    public void addMessageToPreserverWhenNoConsumers() {
        AnypointMQMessage message = this.createTestMessage(ONE);
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.destination.send(message);
        this.prefetcher.start();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)500L))).add((AnypointMQMessage)org.mockito.Matchers.eq((Object)message), org.mockito.Matchers.anyLong());
    }

    @Test
    public void retrieveSkippedWhenCircuitIsOpen() throws InterruptedException {
        this.setCircuitState(MQCircuitBreaker.CircuitState.OPEN);
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1500).never())).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).acquireCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).releaseCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.atMost((int)4))).isOpen();
    }

    @Test
    public void retrieveSkippedWhenTestAlreadyInFlight() throws InterruptedException {
        this.setCircuitState(MQCircuitBreaker.CircuitState.HALF_OPEN);
        this.setDestinationCallBackOnSubscribe(o -> {});
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1500))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.atLeast((int)3))).getState();
    }

    @Test
    public void releaseLockRetrieveOnError() throws InterruptedException {
        this.setCircuitState(MQCircuitBreaker.CircuitState.HALF_OPEN);
        AtomicBoolean lock = new AtomicBoolean(false);
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).then(i -> lock.compareAndSet(false, true));
        Mockito.when((Object)this.circuitBreakerMock.releaseCircuitLock()).then(i -> lock.compareAndSet(true, false));
        this.setDestinationCallBackOnSubscribe(o -> this.testCallbackExecutor.submit(() -> o.onError((Throwable)new RuntimeException("Mock Error"))));
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1500).atLeast(3))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.atLeast((int)3))).releaseCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).acquireCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).awaitCircuitLock(org.mockito.Matchers.anyInt());
    }

    @Test
    public void releaseLockOnEmptyResponse() throws InterruptedException {
        this.setCircuitState(MQCircuitBreaker.CircuitState.HALF_OPEN);
        AtomicBoolean lock = new AtomicBoolean(false);
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).then(i -> lock.compareAndSet(false, true));
        Mockito.when((Object)this.circuitBreakerMock.releaseCircuitLock()).then(i -> lock.compareAndSet(true, false));
        this.setDestinationCallBackOnSubscribe(o -> this.testCallbackExecutor.submit(() -> o.onSuccess((Object)ImmutableList.of())));
        this.prefetcher.start();
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1500).atLeast(3))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.atLeast((int)3))).releaseCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).acquireCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.never())).awaitCircuitLock(org.mockito.Matchers.anyInt());
    }

    @Test
    public void messagesAreNackedIfCircuitIsOpen() throws InterruptedException {
        CountDownLatch latch = this.simulateCircuitOpenDuringReceive();
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        latch.await();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)1000L).times(3))).remove(org.mockito.Matchers.anyString());
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.timeout((long)1000L))).nack((List)org.mockito.Matchers.any(List.class));
    }

    @Test
    public void singleMessageDispatchedWhenWaitingForSuccessResultOnHalfOpen() throws InterruptedException {
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)true);
        ((MQCircuitBreaker)Mockito.doAnswer(i -> {
            this.setCircuitState(MQCircuitBreaker.CircuitState.CLOSED);
            return null;
        }).when((Object)this.circuitBreakerMock)).awaitCircuitLock(org.mockito.Matchers.anyInt());
        CountDownLatch latch = this.simulateHalfOpenDuringRequest();
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        latch.await();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)1000000L).atLeast(1))).acquireCircuitLock();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)1000L))).remove(org.mockito.Matchers.anyString());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L).atLeast(1))).isClosed();
        MatcherAssert.assertThat((Object)this.circuitBreakerMock.isClosed(), (Matcher)Matchers.is((Object)true));
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1000).never())).nack((Lock)org.mockito.Matchers.any(Lock.class));
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.never())).nack((List)org.mockito.Matchers.any(List.class));
    }

    @Test
    public void whenAwaitLockFailsWithInterruptedExceptionContinue() throws InterruptedException {
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)true);
        ((MQCircuitBreaker)Mockito.doAnswer(i -> {
            throw new InterruptedException();
        }).when((Object)this.circuitBreakerMock)).awaitCircuitLock(org.mockito.Matchers.anyInt());
        CountDownLatch latch = this.simulateHalfOpenDuringRequest();
        this.prefetcher.start();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        latch.await();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)1000000L).atLeast(1))).acquireCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).isClosed();
        MatcherAssert.assertThat((Object)this.circuitBreakerMock.isHalfOpen(), (Matcher)Matchers.is((Object)true));
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1000).never())).nack((Lock)org.mockito.Matchers.any(Lock.class));
    }

    @Test
    public void whenTimePassedOnCircuitItShouldStillBeHalfOpen() throws InterruptedException {
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)true);
        CountDownLatch latch = this.simulateHalfOpenDuringRequest();
        this.prefetcher.start();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        latch.await(490000L, TimeUnit.MILLISECONDS);
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)1000000L).atLeast(1))).acquireCircuitLock();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).isClosed();
        MatcherAssert.assertThat((Object)this.circuitBreakerMock.isHalfOpen(), (Matcher)Matchers.is((Object)true));
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1000).never())).nack((Lock)org.mockito.Matchers.any(Lock.class));
    }

    @Test
    public void testMessageDispatchedWaitingForErrorResultOnHalfOpen() throws InterruptedException {
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)true);
        ((MQCircuitBreaker)Mockito.doAnswer(i -> {
            this.setCircuitState(MQCircuitBreaker.CircuitState.OPEN);
            return null;
        }).when((Object)this.circuitBreakerMock)).awaitCircuitLock(org.mockito.Matchers.anyInt());
        CountDownLatch latch = this.simulateHalfOpenDuringRequest();
        MessagePreserver preserverMock = this.getMessagePreserverMock();
        this.prefetcher = new ScheduledPrefetcher((Destination)this.destination, 5, 120000L, 500L, preserverMock, this.circuitBreakerMock, 480000);
        this.prefetcher.start();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        latch.await();
        ((MessagePreserver)Mockito.verify((Object)preserverMock, (VerificationMode)Mockito.timeout((long)1000L).atLeast(3))).remove(org.mockito.Matchers.anyString());
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.after((int)1000))).nack((List)org.mockito.Matchers.any(List.class));
    }

    @Test
    public void skipNackWhenSingleMessageUsedForCircuitTestingFails() throws InterruptedException {
        Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)true);
        ((MQCircuitBreaker)Mockito.doAnswer(i -> {
            this.setCircuitState(MQCircuitBreaker.CircuitState.OPEN);
            return null;
        }).when((Object)this.circuitBreakerMock)).awaitCircuitLock(org.mockito.Matchers.anyInt());
        AtomicBoolean messageDispatched = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.setDestinationCallBackOnSubscribe(o -> {
            this.setCircuitState(MQCircuitBreaker.CircuitState.HALF_OPEN);
            this.testCallbackExecutor.submit(() -> {
                if (messageDispatched.compareAndSet(false, true)) {
                    o.onSuccess(this.createTestMessages(1));
                } else {
                    o.onSuccess((Object)ImmutableList.of());
                }
                latch.countDown();
            });
        });
        this.prefetcher.start();
        this.testCallbackExecutor.schedule(() -> (AnypointMQMessage)this.prefetcher.get().toBlocking().first(), 500L, TimeUnit.MILLISECONDS);
        latch.await();
        ((MQCircuitBreaker)Mockito.verify((Object)this.circuitBreakerMock, (VerificationMode)Mockito.timeout((long)480000L))).awaitCircuitLock(org.mockito.Matchers.anyInt());
        ((TestDestination)Mockito.verify((Object)this.destination, (VerificationMode)Mockito.never())).nack((List)org.mockito.Matchers.any(List.class));
    }

    @Test
    public void startSchedulerOnMissingQueue() {
        Destination destinationMock = (Destination)Mockito.mock(Destination.class);
        Mockito.when((Object)destinationMock.getName()).thenReturn((Object)"myQueue");
        Mockito.when((Object)destinationMock.receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong())).thenAnswer(invocation -> new CourierObservable<List<AnypointMQMessage>>(){

            public void subscribe(CourierObserver<List<AnypointMQMessage>> observer) {
                ScheduledPrefetcherTestCase.this.testCallbackExecutor.submit(() -> observer.onError((Throwable)ScheduledPrefetcherTestCase.this.resourceNotFoundException));
            }

            public List<AnypointMQMessage> getValue() {
                return null;
            }

            public void fireAndForget() {
            }
        });
        this.prefetcher = (ScheduledPrefetcher)Mockito.spy((Object)new ScheduledPrefetcher(destinationMock, 5, 120000L, 500L, null, this.circuitBreakerMock, 480000));
        this.prefetcher.start();
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.timeout((long)500L))).receive(5, 20000L, 120000L);
        ((ScheduledPrefetcher)Mockito.verify((Object)this.prefetcher, (VerificationMode)Mockito.timeout((long)500L))).stop();
    }

    @Test
    public void queueDeletedAfterStart() {
        Destination destinationMock = (Destination)Mockito.mock(Destination.class);
        final AtomicBoolean messageDispatched = new AtomicBoolean(false);
        Mockito.when((Object)destinationMock.getName()).thenReturn((Object)"myQueue");
        Mockito.when((Object)destinationMock.receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong())).thenAnswer(invocation -> new CourierObservable<List<AnypointMQMessage>>(){

            public void subscribe(CourierObserver<List<AnypointMQMessage>> o) {
                ScheduledPrefetcherTestCase.this.testCallbackExecutor.submit(() -> {
                    if (messageDispatched.compareAndSet(false, true)) {
                        o.onSuccess((Object)ScheduledPrefetcherTestCase.this.createTestMessages(10));
                    } else {
                        o.onError((Throwable)ScheduledPrefetcherTestCase.this.resourceNotFoundException);
                    }
                });
            }

            public List<AnypointMQMessage> getValue() {
                return null;
            }

            public void fireAndForget() {
            }
        });
        this.prefetcher = (ScheduledPrefetcher)Mockito.spy((Object)new ScheduledPrefetcher(destinationMock, 30, 120000L, 500L, null, this.circuitBreakerMock, 480000));
        this.prefetcher.start();
        ((Destination)Mockito.verify((Object)destinationMock, (VerificationMode)Mockito.after((int)10000).times(2))).receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong());
        ((ScheduledPrefetcher)Mockito.verify((Object)this.prefetcher, (VerificationMode)Mockito.timeout((long)500L))).stop();
    }

    private List<AnypointMQMessage> createTestMessages(int numberOfMessages) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < numberOfMessages; ++i) {
            list.add((Object)this.createTestMessage(String.valueOf(i)));
        }
        return list.build();
    }

    private AnypointMQMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, IOUtils.toInputStream((String)("body-" + id), (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
    }

    private void setCircuitState(MQCircuitBreaker.CircuitState state) {
        Mockito.when((Object)this.circuitBreakerMock.getState()).thenReturn((Object)state);
        Mockito.when((Object)this.circuitBreakerMock.isOpen()).thenReturn((Object)(state == MQCircuitBreaker.CircuitState.OPEN ? 1 : 0));
        Mockito.when((Object)this.circuitBreakerMock.isClosed()).thenReturn((Object)(state == MQCircuitBreaker.CircuitState.CLOSED ? 1 : 0));
        Mockito.when((Object)this.circuitBreakerMock.isHalfOpen()).thenReturn((Object)(state == MQCircuitBreaker.CircuitState.HALF_OPEN ? 1 : 0));
        if (state != MQCircuitBreaker.CircuitState.HALF_OPEN) {
            Mockito.when((Object)this.circuitBreakerMock.acquireCircuitLock()).thenReturn((Object)false);
            Mockito.when((Object)this.circuitBreakerMock.releaseCircuitLock()).thenReturn((Object)false);
        }
    }

    private void setDestinationCallBackOnSubscribe(final Consumer<CourierObserver<List<AnypointMQMessage>>> callback) {
        Mockito.when(this.destination.receive(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong(), org.mockito.Matchers.anyLong())).thenReturn((Object)new CourierObservable<List<AnypointMQMessage>>(){

            public void subscribe(CourierObserver<List<AnypointMQMessage>> observer) {
                callback.accept(observer);
            }

            public List<AnypointMQMessage> getValue() {
                return null;
            }

            public void fireAndForget() {
            }
        });
    }

    private CountDownLatch simulateCircuitStateChangeDuringReceiveTime(MQCircuitBreaker.CircuitState newState) {
        CountDownLatch latch = new CountDownLatch(1);
        this.setDestinationCallBackOnSubscribe(o -> {
            this.setCircuitState(newState);
            this.testCallbackExecutor.submit(() -> {
                o.onSuccess(this.createTestMessages(3));
                latch.countDown();
            });
        });
        return latch;
    }

    private CountDownLatch simulateCircuitOpenDuringReceive() {
        return this.simulateCircuitStateChangeDuringReceiveTime(MQCircuitBreaker.CircuitState.OPEN);
    }

    private CountDownLatch simulateHalfOpenDuringRequest() {
        return this.simulateCircuitStateChangeDuringReceiveTime(MQCircuitBreaker.CircuitState.HALF_OPEN);
    }

    private MessagePreserver getMessagePreserverMock() {
        MessagePreserver preserverMock = (MessagePreserver)Mockito.mock(MessagePreserver.class);
        Mockito.when((Object)preserverMock.isExpired(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)preserverMock.remove(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        return preserverMock;
    }
}

