/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.circuit;

import com.mulesoft.mq.restclient.api.circuit.CircuitTestingLock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReentrantCircuitTestLock
implements CircuitTestingLock {
    private final AtomicBoolean isLocked = new AtomicBoolean(false);
    private CountDownLatch latch;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReentrantCircuitTestLock.class);

    @Override
    public boolean acquire() {
        LOGGER.debug("ACQUIRE METHOD");
        if (this.isLocked.compareAndSet(false, true)) {
            LOGGER.debug("ACQUIRE METHOD. IS LOCKED");
            this.latch = new CountDownLatch(1);
            LOGGER.debug("ACQUIRE METHOD. CREATED COUNT DOWN LATCH");
            return true;
        }
        LOGGER.debug("ACQUIRE METHOD. IS NOT LOCKED");
        return false;
    }

    @Override
    public boolean await(int circuitLockTTL) throws InterruptedException {
        LOGGER.debug("AWAIT METHOD");
        if (this.isLocked.get()) {
            LOGGER.debug("AWAIT METHOD. IS LOCKED");
            return this.latch.await(circuitLockTTL, TimeUnit.MILLISECONDS);
        }
        LOGGER.debug("AWAIT METHOD. IS NOT LOCKED");
        return true;
    }

    @Override
    public boolean release() {
        LOGGER.debug("RELEASE METHOD");
        if (this.isLocked.compareAndSet(true, false)) {
            LOGGER.debug("RELEASE METHOD. STARTED COUNT DOWN FOR LATCH");
            this.latch.countDown();
            LOGGER.debug("RELEASE METHOD. ENDED COUNT DOWN FOR LATCH");
            this.latch = null;
            return true;
        }
        LOGGER.debug("RELEASE METHOD. DID NOT COUNT DOWN FOR LATCH");
        return false;
    }
}

