/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.CourierObservable;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.utils.TestMessage;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class TestUtils {
    private TestUtils() {
    }

    public static void probe(long timeout, long tryDelay, Runnable assertions) {
        long startTime = System.currentTimeMillis();
        String lastError = null;
        while (System.currentTimeMillis() - startTime < timeout) {
            try {
                assertions.run();
                return;
            }
            catch (Throwable e) {
                lastError = e.getMessage();
                try {
                    Thread.sleep(tryDelay);
                }
                catch (InterruptedException e2) {
                    throw new IllegalStateException("Unexpected interrupt", e2);
                }
            }
        }
        Assert.fail((String)("Timeout - Condition not met: " + lastError));
    }

    public static AnypointMQMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, IOUtils.toInputStream((String)("body-" + id), (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
    }

    public static CountDownLatch setDestinationCallBackOnSubscribe(Destination destination, final ScheduledExecutorService callbackExecutor, final Consumer<CourierObserver<List<AnypointMQMessage>>> callback) {
        final CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)destination.receive(Matchers.anyInt(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)new CourierObservable<List<AnypointMQMessage>>(){

            public void subscribe(CourierObserver<List<AnypointMQMessage>> observer) {
                callbackExecutor.submit(() -> {
                    callback.accept(observer);
                    latch.countDown();
                });
            }

            public List<AnypointMQMessage> getValue() {
                return null;
            }

            public void fireAndForget() {
            }
        });
        return latch;
    }
}

