/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.internal.JsonUtils;
import com.mulesoft.mq.restclient.utils.TestMessage;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.weave.v2.el.FileBasedCursorStream;
import org.mule.weave.v2.el.FileBasedCursorStreamProvider;

public class JsonUtilsTestCase {
    @Test
    public void testSimpleJsonSerialization() {
        InputStream is = IOUtils.toInputStream((String)"hello world", (Charset)Charset.defaultCharset());
        TestMessage msg = new TestMessage("some id", is);
        String jsonString = JsonUtils.toJson((Object)msg);
        Assert.assertEquals((Object)"{\"id\":\"some id\",\"body\":\"hello world\"}", (Object)jsonString);
    }

    @Test
    public void testMessageJsonSerializationWithLargeFileStream() {
        File f = new File(this.getClass().getClassLoader().getResource("test.csv").getFile());
        FileBasedCursorStreamProvider provider = new FileBasedCursorStreamProvider(f);
        FileBasedCursorStream stream = new FileBasedCursorStream(f, provider);
        TestMessage msg = new TestMessage("some id", (InputStream)stream);
        String jsonString = JsonUtils.toJson((Object)msg);
        Assert.assertEquals((long)7693986L, (long)jsonString.length());
    }
}

