/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.utils.AnypointMQFallbackRegionMapping;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConversionUtils {
    private static final String ANYPOINT_DOMAIN_DELIMITER = ".anypoint.mulesoft.com";
    private static final String MQ_REGION_URL_PREFIX = "mq-";
    protected static final Logger LOGGER = LoggerFactory.getLogger(UrlConversionUtils.class);

    public static String getDefaultFallbackRegionUrl(String primaryRegionUrl) {
        try {
            String withoutProtocol = new URI(primaryRegionUrl).toURL().getHost();
            int index = withoutProtocol.indexOf(ANYPOINT_DOMAIN_DELIMITER);
            if (index != -1) {
                String primaryRegion = withoutProtocol.substring(0, index);
                String fallbackRegion = AnypointMQFallbackRegionMapping.getFallbackRegionFromPrimary(primaryRegion);
                return fallbackRegion == null ? null : primaryRegionUrl.replace(primaryRegion, fallbackRegion);
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Exception while trying to get default fallback region for the primary region %s", primaryRegionUrl), (Throwable)e);
        }
        return null;
    }

    public static String getFallbackRegionUrl(String primaryRegionUrl, String fallbackRegion) {
        try {
            String withoutProtocol;
            int index;
            if (fallbackRegion != null && (index = (withoutProtocol = new URI(primaryRegionUrl).toURL().getHost()).indexOf(ANYPOINT_DOMAIN_DELIMITER)) != -1) {
                String primaryRegion = withoutProtocol.substring(0, index);
                primaryRegion = primaryRegion.startsWith(MQ_REGION_URL_PREFIX) ? primaryRegion.substring(MQ_REGION_URL_PREFIX.length()) : primaryRegion;
                primaryRegion = primaryRegion.contains(".") ? primaryRegion.substring(0, primaryRegion.indexOf(46)) : primaryRegion;
                return primaryRegionUrl.replace(primaryRegion, fallbackRegion);
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Exception while trying to get fallback region url for the primary region %s and fallback region %s", primaryRegionUrl, fallbackRegion), (Throwable)e);
        }
        return null;
    }
}

