/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.exception.MQClientConnectionException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.utils.MockCourierServer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import rx.Observable;

public abstract class AbstractCourierRestClientTestCase {
    public int httpPort = new Random().nextInt(30000) + 10000;
    private static final String ORGANIZATION_ID = "no-org";
    private static final String ENVIRONMENT_ID = "no-env";
    protected MockCourierServer server;
    protected OAuthCredentials oAuthCredential;
    protected AbstractCourierRestClient client;
    protected DestinationLocation mockDestinationLocation = new DestinationLocationBuilder().setOrganizationId("no-org").setEnvironmentId("no-env").setName("some-destination").build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public void setup(int expectedRequests) throws Exception {
        this.setup(expectedRequests, MockCourierServer.OAUTH_CREDENTIALS);
    }

    public void setup(int expectedRequests, OAuthCredentials oAuthCredential) throws Exception {
        this.setup(expectedRequests, oAuthCredential, false);
    }

    public void setup(int expectedRequests, boolean failOnServiceRegistryRequest) throws Exception {
        this.setup(expectedRequests, MockCourierServer.OAUTH_CREDENTIALS, failOnServiceRegistryRequest);
    }

    public void setup(int expectedRequests, OAuthCredentials oAuthCredential, boolean failOnServiceRegistryRequest) throws Exception {
        this.oAuthCredential = oAuthCredential;
        this.server = new MockCourierServer(this.httpPort, expectedRequests, failOnServiceRegistryRequest);
        this.createClient();
    }

    protected String apiUrl3x() {
        return "http://localhost:" + this.httpPort + "/api/v1";
    }

    protected String apiUrl4x() {
        return "http://localhost:" + this.httpPort + "/api/v1/organizations/" + ORGANIZATION_ID + "/environments/" + ENVIRONMENT_ID;
    }

    protected abstract void createClient() throws Exception;

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            MockCourierServer serverCopy = this.server;
            this.server = null;
            serverCopy.stop();
        }
        if (this.client != null) {
            this.client.dispose();
        }
    }

    @Test
    public void credentialsOk() throws Exception {
        this.setup(2);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    @Test
    public void wrongCredentials() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: AUTHORIZE AGAINST AUTH SERVER. Cause: Can not login into Authentication Server"));
        this.setup(3, new OAuthCredentials("client-id", "wrong-client-secret"));
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES);
        observableOfMessages.toBlocking().first();
    }

    @Test
    public void whenServiceRegistryEndpointIsDownItShouldRetryAndFail() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: GET SERVICE REGISTRY AGAINST BROKER. Cause: Can not get url from service registry"));
        this.setup(AbstractCourierRestClient.MAX_RETRIES + 1, true);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
    }

    @Test
    public void send() throws Exception {
        this.setup(3);
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withMessageId("someMessageId");
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody(IOUtils.toInputStream((String)"Some body", (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        messageBuilder.addHeader("Some Header", (Object)"Some Header value");
        messageBuilder.addProperty("Some Property", (Object)"Some Property value");
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messageBuilder.build(), false, AbstractCourierRestClient.MAX_RETRIES);
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
    }

    @Test
    public void addPropertyWithNotSupportedValuesWillFail() throws IllegalArgumentException {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.addProperty("Accepted Value 1", (Object)2);
        messageBuilder.addProperty("Accepted Value 2", (Object)10.3);
        messageBuilder.addProperty("Accepted Value 3", (Object)5.99);
        messageBuilder.addProperty("Accepted Value 4", (Object)true);
        messageBuilder.addProperty("Accepted Value 5", (Object)"false");
        messageBuilder.addProperty("Accepted Value 6", (Object)"randomStringValue");
        messageBuilder.addProperty("Accepted Value 7", (Object)"123hfsa09q234asf@!#$!@#%$^");
        try {
            int[] emptyArray = new int[1];
            messageBuilder.addProperty("Some Property", (Object)emptyArray);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Property value accept only string or number or boolean as values"));
        }
        try {
            int[] someArray = new int[]{1, 2, 3};
            messageBuilder.addProperty("Some Property", (Object)someArray);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Property value accept only string or number or boolean as values"));
        }
    }

    @Test
    public void addHeaderWithNotSupportedValuesWillFail() throws IllegalArgumentException {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.addHeader("Accepted Value 1", (Object)2);
        messageBuilder.addHeader("Accepted Value 2", (Object)10.3);
        messageBuilder.addHeader("Accepted Value 3", (Object)5.99);
        messageBuilder.addHeader("Accepted Value 4", (Object)"randomStringValue");
        messageBuilder.addHeader("Accepted Value 5", (Object)"123hfsa09q234asf@!#$!@#%$^");
        messageBuilder.addProperty("Accepted Value 6", (Object)true);
        messageBuilder.addProperty("Accepted Value 7", (Object)"false");
        try {
            int[] emptyArray = new int[1];
            messageBuilder.addHeader("Some Header1", (Object)emptyArray);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Header value accept only string or number or boolean as values"));
        }
        try {
            int[] someArray = new int[]{1, 2, 3};
            messageBuilder.addHeader("Some Header2", (Object)someArray);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Header value accept only string or number or boolean as values"));
        }
    }

    @Test
    public void sendBatch() throws Exception {
        this.setup(3);
        List<AnypointMQMessage> messages = Arrays.asList(this.createMessage("0"), this.createMessage("1"), this.createMessage("2"));
        Observable observableOfResult = this.client.send(this.mockDestinationLocation, messages, false, AbstractCourierRestClient.MAX_RETRIES);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Send operation successful"));
        }
    }

    @Test
    public void receive() throws Exception {
        this.setup(4);
        Observable observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES);
        List messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
        AnypointMQMessage message = (AnypointMQMessage)messages.get(0);
        Assert.assertThat((Object)message.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat(message.getHeaders().get("lockId"), (Matcher)Is.is((Object)"someLockId"));
        Assert.assertThat(message.getProperties().get("userDefinedProperty"), (Matcher)Is.is((Object)"User defined stuff"));
        Assert.assertThat(message.getProperties().get("anotherUserDefinedProperty"), (Matcher)Is.is((Object)"Random stuff"));
        Assert.assertThat((Object)message.getProperties().get("numericUserDefinedProperty").toString(), (Matcher)Is.is((Object)"500"));
        Assert.assertThat(message.getProperties().get("numericUserDefinedProperty"), (Matcher)Is.is((Object)500L));
        Assert.assertThat((Object)message.getBodyAsString(), (Matcher)Is.is((Object)"This is a message payload"));
        observableOfMessages = this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES);
        messages = (List)observableOfMessages.toBlocking().first();
        Assert.assertThat((Object)messages.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void ack() throws Exception {
        this.setup(3);
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, new Lock("someMessageId", "someLockId"), false);
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"ACK operation successful"));
    }

    @Test
    public void ackBatch() throws Exception {
        this.setup(3);
        List<Lock> locks = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.ack(this.mockDestinationLocation, locks, false);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"ACK operation successful"));
        }
    }

    @Test
    public void nack() throws Exception {
        this.setup(3);
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, new Lock("someMessageId", "someLockId"), false);
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"NACK operation successful"));
    }

    @Test
    public void nackBatch() throws Exception {
        this.setup(3);
        List<Lock> locks = Arrays.asList(this.getLockId("0"), this.getLockId("1"), this.getLockId("2"));
        Observable observableOfResult = this.client.nack(this.mockDestinationLocation, locks, false);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"NACK operation successful"));
        }
    }

    @Test
    public void modifyTtl() throws Exception {
        this.setup(3);
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, new NewTtl("someMessageId", "someLockId", 1000L), false);
        MessageIdResult result = (MessageIdResult)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)"someMessageId"));
        Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
        Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Modify Lock Ttl operation successful"));
    }

    @Test
    public void modifyTtlBatch() throws Exception {
        this.setup(3);
        List<NewTtl> newTtls = Arrays.asList(this.getNewTtl("0"), this.getNewTtl("1"), this.getNewTtl("2"));
        Observable observableOfResult = this.client.modifyTtl(this.mockDestinationLocation, newTtls, false);
        List results = (List)observableOfResult.toBlocking().first();
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            MessageIdResult result = (MessageIdResult)results.get(i);
            Assert.assertThat((Object)result.getMessageId(), (Matcher)Is.is((Object)("someMessageId" + i)));
            Assert.assertThat((Object)result.getStatus(), (Matcher)Is.is((Object)"successful"));
            Assert.assertThat((Object)result.getStatusMessage(), (Matcher)Is.is((Object)"Modify Lock Ttl operation successful"));
        }
    }

    @Test(expected=RuntimeException.class)
    public void tooManyRequests() throws Exception {
        this.setup(2);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
    }

    @Test(expected=RuntimeException.class)
    public void tooFewRequests() throws Exception {
        this.setup(4);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
        this.tearDown();
    }

    @Test
    public void retryOnTokenExpiration() throws Exception {
        this.setup(5);
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        this.server.setFailAuthOnNextRequest(true);
        List messages = (List)this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
        Assert.assertThat((Object)messages, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void throwExceptionIfClientAlreadyDisposed() throws Exception {
        this.setup(3);
        this.server.setFailAuthOnNextRequest(false);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
        this.client.dispose();
        try {
            this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
            Assert.fail((String)"Expected a connection exception to be thrown");
        }
        catch (MQClientConnectionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Client has already been disposed"));
        }
    }

    @Test
    public void connAppCredentialsShouldPass() throws Exception {
        this.setup(3, new OAuthCredentials("conn-app-client-id", "conn-app-client-secret"));
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    @Test
    public void connAppIncorrectCredentialsShouldFail() throws Exception {
        this.expectedException.expect(RestException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"An error occurred while executing the operation: AUTHORIZE AGAINST AUTH SERVER. Cause: Can not login into Authentication Server"));
        this.setup(3, new OAuthCredentials("conn-app-client-id", "wrong-client-secret"));
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void retryOnConnAppTokenExpiration() throws Exception {
        this.setup(6, new OAuthCredentials("conn-app-client-id", "conn-app-client-secret"));
        Assert.assertThat((Object)this.client.getAccessToken(), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        this.server.setFailAuthOnNextRequest(true);
        List messages = (List)this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
        Assert.assertThat((Object)messages, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void throwExceptionIfConnAppClientAlreadyDisposed() throws Exception {
        this.setup(4, new OAuthCredentials("conn-app-client-id", "conn-app-client-secret"));
        this.server.setFailAuthOnNextRequest(false);
        this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
        this.client.dispose();
        try {
            this.client.receive(this.mockDestinationLocation, 0, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES).toBlocking().first();
            Assert.fail((String)"Expected a connection exception to be thrown");
        }
        catch (MQClientConnectionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Client has already been disposed"));
        }
    }

    private AnypointMQMessage createMessage(String postfix) {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withMessageId("someMessageId" + (postfix != null ? postfix : ""));
        messageBuilder.withLockId("Some lock id");
        messageBuilder.withBody(IOUtils.toInputStream((String)"Some body", (Charset)AnypointMQMessage.DEFAULT_BODY_CHARSET));
        messageBuilder.addHeader("Some Header", (Object)"Some Header value");
        messageBuilder.addProperty("Some Property", (Object)"Some Property value");
        return messageBuilder.build();
    }

    private Lock getLockId(String postfix) {
        return new Lock("someMessageId" + postfix, "someLockId" + postfix);
    }

    private NewTtl getNewTtl(String postfix) {
        return new NewTtl("someMessageId" + postfix, "someLockId" + postfix, 1000L);
    }
}

