/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.mq.domain.DefaultAnypointMQMessage;
import com.mulesoft.mq.restclient.utils.JsonUtils;
import com.mulesoft.mq.restclient.utils.TestMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.weave.v2.el.FileBasedCursorStream;
import org.mule.weave.v2.el.FileBasedCursorStreamProvider;

public class JsonUtilsTestCase {
    @Test
    public void testDefaultAnypointMQMessageJsonSerialization() {
        ByteArrayInputStream stream = new ByteArrayInputStream("test".getBytes(StandardCharsets.UTF_8));
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        headers.put("key2", "value2");
        properties.put("key2", "value2");
        DefaultAnypointMQMessage damqm = new DefaultAnypointMQMessage((InputStream)stream, headers, properties);
        String jsonString = JsonUtils.toJson((Object)damqm);
        Assert.assertTrue((boolean)jsonString.equals("{\"body\":\"test\",\"headers\":{\"key2\":\"value2\"},\"properties\":{\"key2\":\"value2\"}}"));
    }

    @Test
    public void testSimpleJsonSerialization() {
        InputStream is = IOUtils.toInputStream((String)"hello world", (Charset)Charset.defaultCharset());
        TestMessage msg = new TestMessage("some id", is);
        String jsonString = JsonUtils.toJson((Object)msg);
        Assert.assertEquals((Object)"{\"id\":\"some id\",\"body\":\"hello world\"}", (Object)jsonString);
    }

    @Test
    public void testMessageJsonSerializationWithLargeFileStream() {
        File f = new File(this.getClass().getClassLoader().getResource("test.csv").getFile());
        FileBasedCursorStreamProvider provider = new FileBasedCursorStreamProvider(f);
        FileBasedCursorStream stream = new FileBasedCursorStream(f, provider);
        TestMessage msg = new TestMessage("some id", (InputStream)stream);
        String jsonString = JsonUtils.toJson((Object)msg);
        Assert.assertEquals((long)7693986L, (long)jsonString.length());
    }
}

