/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.mq.CourierUrlBuilder;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DestinationLocationBuilder;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CourierUrlBuilderTest
extends TestCase {
    private DestinationLocation mockDestinationLocation = new DestinationLocationBuilder().setOrganizationId("no-org").setEnvironmentId("no-env").setName("some-destination").build();
    private CourierUrlBuilder urlBuilder;
    private final String toBeEncodedMesagedId = "a^/#%^7*/c102394857\\66()!_;:,.-'@#%";
    private final String lockId = "someLockId";
    private final String toBeEncodedLockId = "/4*/";
    private final String messagedId = "someMessageId";

    @Test
    public void testMessageIdEncoding() {
        this.urlBuilder = new CourierUrlBuilder("baseURI");
        String encodedString = this.urlBuilder.message(this.mockDestinationLocation, "a^/#%^7*/c102394857\\66()!_;:,.-'@#%");
        MatcherAssert.assertThat((Object)encodedString, (Matcher)Matchers.containsString((String)"%2F"));
    }

    @Test
    public void testMessageIdInLockEncoding() {
        this.urlBuilder = new CourierUrlBuilder("baseURI");
        String encodedString = this.urlBuilder.lock(this.mockDestinationLocation, "a^/#%^7*/c102394857\\66()!_;:,.-'@#%", "someLockId");
        MatcherAssert.assertThat((Object)encodedString, (Matcher)Matchers.containsString((String)"%2F"));
    }

    @Test
    public void testLockIdEncoding() {
        this.urlBuilder = new CourierUrlBuilder("baseURI");
        String encodedString = this.urlBuilder.lock(this.mockDestinationLocation, "someMessageId", "/4*/");
        MatcherAssert.assertThat((Object)encodedString, (Matcher)Matchers.containsString((String)"%2F"));
    }
}

