/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.google.common.collect.ImmutableList;
import com.mulesoft.mq.restclient.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.impl.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.utils.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PrefetchedDestinationTestCase {
    @Mock
    private MQCircuitBreaker circuitBreaker;
    @Mock
    private MessagePreserver messagePreserver;
    @Mock
    private Destination destinationMock;
    private PrefetchedDestination prefetchedDestination;
    private ScheduledPrefetcher prefetcher;
    private ScheduledExecutorService testExecutor;

    @Before
    public void setup() {
        int batchSize = 3;
        long retrieveFrequency = 5000L;
        long lockTimeToLive = 120000L;
        this.testExecutor = Executors.newSingleThreadScheduledExecutor();
        Mockito.when((Object)this.messagePreserver.isExpired(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.messagePreserver.remove(org.mockito.Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.getState()).thenReturn((Object)MQCircuitBreaker.CircuitState.CLOSED);
        Mockito.when((Object)this.circuitBreaker.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.circuitBreaker.isOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.isHalfOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.acquireCircuitLock()).thenReturn((Object)false);
        Mockito.when((Object)this.circuitBreaker.releaseCircuitLock()).thenReturn((Object)false);
        this.prefetcher = new ScheduledPrefetcher(this.destinationMock, 3, 120000L, 5000L, this.messagePreserver, this.circuitBreaker, 480000);
        this.prefetchedDestination = new PrefetchedDestination(this.destinationMock, (Prefetcher)this.prefetcher);
    }

    @After
    public void tearDown() {
        this.prefetcher.stop();
        this.testExecutor.shutdown();
    }

    @Test
    public void retrieveMessagesOnlyOnceManyGets() throws InterruptedException {
        AtomicBoolean dispatched = new AtomicBoolean(false);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.NOT_CONFIGURED);
        CountDownLatch latch = TestUtils.setDestinationCallBackOnSubscribe(this.destinationMock, this.testExecutor, o -> {
            if (dispatched.compareAndSet(false, true)) {
                o.onSuccess((Object)ImmutableList.of((Object)TestUtils.createTestMessage("0"), (Object)TestUtils.createTestMessage("1"), (Object)TestUtils.createTestMessage("2")));
            }
        });
        this.prefetcher.start();
        latch.await();
        ArrayList<String> ids = new ArrayList<String>(3);
        ids.add(((AnypointMQMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getMessageId());
        ids.add(((AnypointMQMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getMessageId());
        ids.add(((AnypointMQMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getMessageId());
        Assert.assertThat(ids, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"id-0", "id-1", "id-2"}));
    }
}

