/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.circuit.impl;

import com.mulesoft.mq.restclient.circuit.CircuitTestingLock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReentrantCircuitTestLock
implements CircuitTestingLock {
    private final AtomicBoolean isLocked = new AtomicBoolean(false);
    private CountDownLatch latch;

    @Override
    public boolean acquire() {
        if (this.isLocked.compareAndSet(false, true)) {
            this.latch = new CountDownLatch(1);
            return true;
        }
        return false;
    }

    @Override
    public boolean await(int circuitLockTTL) throws InterruptedException {
        if (this.isLocked.get()) {
            return this.latch.await(circuitLockTTL, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    @Override
    public boolean release() {
        if (this.isLocked.compareAndSet(true, false)) {
            this.latch.countDown();
            this.latch = null;
            return true;
        }
        return false;
    }
}

