/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.utils.UrlConversionUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CourierUrlBuilder {
    private static final String DESTINATION_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s";
    private static final String FALLBACK_CONFIG_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/fallbackConfig";
    private static final String MESSAGE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages";
    private static final String MESSAGE_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s";
    private static final String LOCK_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/locks";
    private static final String LOCK_INSTANCE_PATTERN = "%s/organizations/%s/environments/%s/destinations/%s/messages/%s/locks/%s";
    private final String baseUri;
    private final String fallbackBaseUri;

    public CourierUrlBuilder(String baseUri, String fallbackBaseUri) {
        this.baseUri = baseUri;
        this.fallbackBaseUri = fallbackBaseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String serviceRegistryUrl() {
        return this.serviceRegistryUrl(false);
    }

    public String serviceRegistryUrl(boolean useBackupRegion) {
        String primaryRegionUrl = this.baseUri + "/serviceRegistry";
        if (useBackupRegion) {
            return UrlConversionUtils.getBackupRegionUrl(primaryRegionUrl, true);
        }
        return primaryRegionUrl;
    }

    public String encode(String idToBeEncoded, String encodingType) throws UnsupportedEncodingException {
        return URLEncoder.encode(idToBeEncoded, encodingType);
    }

    public String fallbackConfig(DestinationLocation destinationLocation, Boolean useFallbackDestination) {
        if (useFallbackDestination.booleanValue()) {
            return String.format(FALLBACK_CONFIG_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName());
        }
        return String.format(FALLBACK_CONFIG_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String messages(DestinationLocation destinationLocation) {
        return this.messages(destinationLocation, false);
    }

    public String messages(DestinationLocation destinationLocation, Boolean useFallbackDestination) {
        if (useFallbackDestination.booleanValue()) {
            return String.format(MESSAGE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName());
        }
        return String.format(MESSAGE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }

    public String message(DestinationLocation destinationLocation, String messageId) {
        return this.message(destinationLocation, messageId, false);
    }

    public String message(DestinationLocation destinationLocation, String messageId, Boolean useFallbackDestination) {
        String encodedMessageId;
        try {
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedMessageId = "someMessageIdValue";
        }
        if (useFallbackDestination.booleanValue()) {
            return String.format(MESSAGE_INSTANCE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName(), encodedMessageId);
        }
        return String.format(MESSAGE_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId) {
        return this.lock(destinationLocation, messageId, lockId, false);
    }

    public String lock(DestinationLocation destinationLocation, String messageId, String lockId, boolean usedFallbackDestination) {
        String encodedMessageId;
        String encodedLockId;
        try {
            encodedLockId = this.encode(lockId, "UTF-8");
            encodedMessageId = this.encode(messageId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encodedLockId = "ERROR";
            encodedMessageId = "someMessageIdValue";
        }
        if (usedFallbackDestination) {
            return String.format(LOCK_INSTANCE_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName(), encodedMessageId, encodedLockId);
        }
        return String.format(LOCK_INSTANCE_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName(), encodedMessageId, encodedLockId);
    }

    public String locks(DestinationLocation destinationLocation) {
        return this.locks(destinationLocation, false);
    }

    public String locks(DestinationLocation destinationLocation, boolean usedFallbackDestination) {
        if (usedFallbackDestination) {
            return String.format(LOCK_PATTERN, this.fallbackBaseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getFallbackName());
        }
        return String.format(LOCK_PATTERN, this.baseUri, destinationLocation.getOrganizationId(), destinationLocation.getEnvironmentId(), destinationLocation.getName());
    }
}

