/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.impl;

import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.impl.LockedMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchedDestination
implements Destination {
    private Destination delegate;
    private Prefetcher prefetcher;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefetchedDestination.class);

    public PrefetchedDestination(Destination destination, Prefetcher prefetcher) {
        this.delegate = destination;
        this.prefetcher = prefetcher;
    }

    @Override
    public CourierObservable<List<AnypointMQMessage>> receive() {
        return new DefaultCourierObservable<List<AnypointMQMessage>>(this.prefetcher.get().toList());
    }

    @Override
    public CourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl) {
        LOGGER.debug("prefetchedDestination.receive()");
        return this.receive();
    }

    @Override
    public CourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl, Boolean useFallbackDestination) {
        return this.receive();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public CourierObservable<MessageIdResult> send(AnypointMQMessage message, Boolean useFallbackDestination, Integer retryCount) {
        return this.delegate.send(message, useFallbackDestination, retryCount);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages, Boolean useFallbackDestination, Integer retryCount) {
        return this.delegate.send(messages, useFallbackDestination, retryCount);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> ack(List<Lock> locks) {
        return this.delegate.ack(locks);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> ack(List<Lock> locks, boolean usedFallbackDestination) {
        return this.delegate.ack(locks, usedFallbackDestination);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> nack(List<Lock> locks, boolean useFallbackDestination) {
        return this.delegate.nack(locks, useFallbackDestination);
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock) {
        return this.delegate.ack(lock);
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock, boolean usedFallbackDestination) {
        return this.delegate.ack(lock, usedFallbackDestination);
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock) {
        return this.delegate.nack(lock);
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock, boolean usedFallbackDestination) {
        return this.delegate.nack(lock, usedFallbackDestination);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval) {
        return this.delegate.modifyLockInterval(messages, lockInterval);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval, boolean usedFallbackDestination) {
        return this.delegate.modifyLockInterval(messages, lockInterval, usedFallbackDestination);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        return this.delegate.modifyLockInterval(lockedMessages);
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages, boolean usedFallbackDestination) {
        return this.delegate.modifyLockInterval(lockedMessages, usedFallbackDestination);
    }

    @Override
    public AnypointMQMessageBuilder newMessageBuilder() {
        return this.delegate.newMessageBuilder();
    }
}

