/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AckNackFallbackConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageErrorResult;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageConfiguration;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.impl.TimeSupplier;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FallbackUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackUtils.class);
    public static final String FALLBACK_SUFFIX = "_fb";
    private static final TimeSupplier TIME_SUPPLIER = new TimeSupplier();
    private static final Random RANDOM = new Random();
    private static final double JITTER_PERCENTAGE = 0.1;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;

    private FallbackUtils() {
    }

    private static double getJitteredValueOfPrimaryRegionCheckInterval(int primaryRegionCheckInterval) {
        double jitter = (double)primaryRegionCheckInterval * 0.1 * (RANDOM.nextDouble() * 2.0 - 1.0);
        return (double)primaryRegionCheckInterval + jitter;
    }

    private static boolean shouldTryPrimaryRegion(Long primaryRegionStatusLastChecked, Integer primaryRegionCheckIntervalMilliseconds) {
        return (double)(TIME_SUPPLIER.get() - primaryRegionStatusLastChecked) >= FallbackUtils.getJitteredValueOfPrimaryRegionCheckInterval(primaryRegionCheckIntervalMilliseconds);
    }

    private static void fetchFallbackConfigurationFromBackend(final Destination destination, final boolean useFallbackDestination) {
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.UNKNOWN)) {
            LOGGER.debug("Sending backend request to fetch fallback config for destination: " + destination);
            destination.fetchFallbackConfiguration(useFallbackDestination).subscribe(new CourierObserver<FallbackConfigResult>(){

                @Override
                public void onSuccess(FallbackConfigResult fallbackConfigResult) {
                    LOGGER.debug("Successful response from fallback config API: " + fallbackConfigResult.toString());
                    if (fallbackConfigResult.getIsFallbackEnabled() != null) {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.CONFIGURED);
                    } else {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    LOGGER.debug("Error while trying to fetch fallback configuration from backend: " + e.getMessage());
                    int statusCode = FallbackUtils.getStatusCode(e);
                    if (!useFallbackDestination) {
                        if (statusCode >= 404 && statusCode < 500 && statusCode != 429) {
                            if (statusCode == 403) {
                                LOGGER.debug("Unable to fetch information about fallback configuration: Client id doesn't have permissions, possibly because user didn't configure 'View destinations' scope");
                            }
                            destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                        } else {
                            LOGGER.debug("Fetching fallback configuration from fallback destination");
                            FallbackUtils.fetchFallbackConfigurationFromBackend(destination, true);
                        }
                    } else if (statusCode != 429) {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                    }
                }
            });
            if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
                LOGGER.info("Fallback feature is enabled for the destination: " + destination.getName());
            } else {
                LOGGER.info("Fallback feature is not enabled for the destination: " + destination.getName());
            }
        }
    }

    private static int getStatusCode(Throwable e) {
        int statusCode = 0;
        try {
            if (e instanceof RestException) {
                statusCode = ((RestException)e).getResponse().get().getStatusCode();
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Unable to retrieve error code: " + e1.getMessage() + " from the API error: " + e.getMessage());
        }
        return statusCode;
    }

    public static PublishMessageConfiguration determinePublishMessageConfiguration(Destination destination, int primaryRegionCheckIntervalMilliseconds) {
        PublishMessageConfiguration publishMessageConfiguration = new PublishMessageConfiguration(false, AbstractCourierRestClient.MAX_RETRIES);
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED) && destination.getPrimaryRegionDown().booleanValue()) {
            if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionCheckIntervalMilliseconds)) {
                publishMessageConfiguration.setRetryCount(0);
            } else {
                publishMessageConfiguration.setUseFallbackDestination(true);
            }
        }
        return publishMessageConfiguration;
    }

    public static void updateFallbackStateOnPublishSuccess(Destination destination, boolean useFallbackDestination) {
        if (!useFallbackDestination) {
            destination.setPrimaryRegionDown(false);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
        }
    }

    public static PublishMessageErrorResult updateFallbackStateOnPublishError(Throwable e, Destination destination, boolean useFallbackDestination) {
        PublishMessageErrorResult publishMessageErrorResult = new PublishMessageErrorResult(false, String.format("Failed to publish message to destination '%s': %s", destination.getName(), e.getMessage()));
        int statusCode = FallbackUtils.getStatusCode(e);
        if (useFallbackDestination) {
            if (e instanceof ResourceNotFoundException) {
                destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                publishMessageErrorResult.setMsg(String.format("Failed to publish message to destination '%s' as primary region is unavailable and fallback destination is not configured: %s", destination.getName(), e.getMessage()));
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
                if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
                    publishMessageErrorResult.setMakeCallToFallback(true);
                }
            }
        }
        return publishMessageErrorResult;
    }

    public static ReceiveMessageConfiguration determineReceiveMessageConfiguration(Destination destination, int primaryRegionCheckIntervalMilliseconds, int fallbackMessagesCheckIntervalMilliseconds) {
        ReceiveMessageConfiguration receiveMessageConfiguration = new ReceiveMessageConfiguration(false, false);
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
            Long fallbackMessagesLastChecked = destination.getFallbackMessagesLastChecked();
            if (fallbackMessagesLastChecked != null) {
                LOGGER.debug("Fallback messages last checked: " + (TIME_SUPPLIER.get() - fallbackMessagesLastChecked) + " milliseconds ago");
                LOGGER.debug("Fallback messages check interval in ms: " + fallbackMessagesCheckIntervalMilliseconds);
            } else {
                LOGGER.debug("Fallback messages last checked = null");
            }
            if (fallbackMessagesLastChecked != null && TIME_SUPPLIER.get() - fallbackMessagesLastChecked < (long)fallbackMessagesCheckIntervalMilliseconds) {
                if (destination.getFallbackHasMessages().booleanValue() || destination.getPrimaryRegionDown().booleanValue() && !FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionCheckIntervalMilliseconds)) {
                    LOGGER.debug("Consume from fallback");
                    receiveMessageConfiguration.setUseFallbackDestination(true);
                } else {
                    LOGGER.debug("Consume from primary");
                    receiveMessageConfiguration.setUseFallbackDestination(false);
                }
            } else {
                LOGGER.debug("Info on whether fallback has messages is either unknown or outdated, short polling from fallback region");
                receiveMessageConfiguration.setUseFallbackDestination(true);
                receiveMessageConfiguration.setShortPolling(true);
            }
        } else {
            LOGGER.debug("Fallback not configured, consuming from primary only");
            receiveMessageConfiguration.setUseFallbackDestination(false);
        }
        return receiveMessageConfiguration;
    }

    public static boolean updateFallbackStateOnReceiveSuccess(List<AnypointMQMessage> messages, Destination destination, boolean useFallbackDestination, int primaryRegionCheckIntervalMilliseconds) {
        boolean makeCallToPrimary = false;
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
            if (!useFallbackDestination) {
                if (destination.getPrimaryRegionDown().booleanValue()) {
                    destination.setFallbackMessagesLastChecked(null);
                }
                destination.setPrimaryRegionDown(false);
                destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            } else {
                destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            }
            if (messages != null && messages.size() > 0) {
                if (useFallbackDestination) {
                    destination.setFallbackHasMessages(true);
                }
            } else {
                LOGGER.debug("No messages received");
                if (useFallbackDestination) {
                    destination.setFallbackHasMessages(false);
                    if (destination.getPrimaryRegionDown().booleanValue() && !FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionCheckIntervalMilliseconds)) {
                        destination.setFallbackHasMessages(true);
                    } else {
                        makeCallToPrimary = true;
                    }
                }
            }
        }
        return makeCallToPrimary;
    }

    public static boolean updateFallbackStateOnReceiveError(Throwable e, Destination destination, boolean useFallbackDestination, int primaryRegionCheckIntervalMilliseconds) {
        boolean makeCallToPrimary = false;
        int statusCode = FallbackUtils.getStatusCode(e);
        if (useFallbackDestination) {
            destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            destination.setFallbackHasMessages(false);
            if (destination.getPrimaryRegionDown().booleanValue() && !FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionCheckIntervalMilliseconds)) {
                destination.setFallbackHasMessages(true);
            } else {
                makeCallToPrimary = true;
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
                if (destination.getPrimaryRegionDown().booleanValue()) {
                    destination.setFallbackMessagesLastChecked(null);
                }
            } else {
                destination.setPrimaryRegionDown(true);
                destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
                destination.setFallbackHasMessages(true);
            }
        }
        return makeCallToPrimary;
    }

    public static AckNackFallbackConfiguration getAckNackFallbackConfiguration(String destination) {
        AckNackFallbackConfiguration ackNackFallbackConfig = new AckNackFallbackConfiguration(false, destination);
        if (destination.endsWith(FALLBACK_SUFFIX)) {
            ackNackFallbackConfig.setUseFallbackDestination(true);
            ackNackFallbackConfig.setDestination(ackNackFallbackConfig.getDestination().substring(0, ackNackFallbackConfig.getDestination().length() - FALLBACK_SUFFIX.length()));
        }
        return ackNackFallbackConfig;
    }

    public static void updateFallbackStateOnAckNackError(Throwable e, Destination destination, boolean useFallbackDestination) {
        if (!useFallbackDestination) {
            int statusCode = FallbackUtils.getStatusCode(e);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
            }
        }
    }
}

