/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AckNackFallbackConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageErrorResult;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageResult;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.impl.TimeSupplier;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FallbackUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackUtils.class);
    public static final String FALLBACK_SUFFIX = "_fb";
    private static final TimeSupplier TIME_SUPPLIER = new TimeSupplier();
    private static final Random RANDOM = new Random();
    private static final double JITTER_PERCENTAGE = 0.1;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;

    private FallbackUtils() {
    }

    private static double getPrimaryRegionStatusCheckIntervalWithJitter(int primaryRegionStatusCheckIntervalMs) {
        double jitter = (double)primaryRegionStatusCheckIntervalMs * 0.1 * (RANDOM.nextDouble() * 2.0 - 1.0);
        return (double)primaryRegionStatusCheckIntervalMs + jitter;
    }

    private static boolean shouldTryPrimaryRegion(long primaryRegionStatusLastChecked, Integer primaryRegionStatusCheckIntervalMs) {
        return (double)(TIME_SUPPLIER.get() - primaryRegionStatusLastChecked) >= FallbackUtils.getPrimaryRegionStatusCheckIntervalWithJitter(primaryRegionStatusCheckIntervalMs);
    }

    protected static void fetchFallbackConfigurationFromBackend(final Destination destination, final boolean useFallbackDestination) {
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.UNKNOWN)) {
            LOGGER.debug(String.format("Fetching cross region failover configuration for the destination '%s'.", destination.getName()));
            destination.fetchFallbackConfiguration(useFallbackDestination, 0).subscribe(new CourierObserver<FallbackConfigResult>(){

                @Override
                public void onSuccess(FallbackConfigResult fallbackConfigResult) {
                    if (fallbackConfigResult.getIsFallbackEnabled() != null && fallbackConfigResult.getIsFallbackEnabled().booleanValue()) {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.CONFIGURED);
                        LOGGER.info("Fallback destination is configured for the destination: " + destination.getName());
                    } else {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                        LOGGER.info("Fallback destination is not configured for the destination: " + destination.getName());
                    }
                }

                @Override
                public void onError(Throwable e) {
                    int statusCode = FallbackUtils.getStatusCode(e);
                    if (statusCode >= 400 && statusCode < 500) {
                        if (statusCode == 401 || statusCode == 429) {
                            LOGGER.debug(String.format("Could not fetch cross region failover configuration for destination '%s'. Will retry in next attempt. Reason: %s.", destination.getName(), statusCode));
                        } else {
                            String reason = statusCode == 403 ? "Provided client ID lacks enough permissions" : "status code " + statusCode;
                            LOGGER.warn(String.format("Unable to fetch cross region failover configuration for destination '%s'. Reason: %s. Setting fallback destination as not configured.", destination.getName(), reason));
                            destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                        }
                    } else if (useFallbackDestination) {
                        LOGGER.debug(String.format("Error while trying to fetch fallback configuration for destination '%s'. Will retry in next attempt. Reason: %s.", destination.getName(), e.getMessage()));
                    } else {
                        LOGGER.debug("Fetching fallback configuration from fallback region");
                        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, true);
                    }
                }
            });
        }
    }

    private static int getStatusCode(Throwable e) {
        int statusCode = 0;
        try {
            Optional<Response> response;
            if (e instanceof RestException && (response = ((RestException)e).getResponse()).isPresent()) {
                statusCode = response.get().getStatusCode();
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Unable to retrieve error code from exception. Setting status code as 0. Reason: " + e1.getMessage());
        }
        return statusCode;
    }

    public static PublishMessageConfiguration determinePublishMessageConfiguration(Destination destination, int primaryRegionStatusCheckIntervalMs, boolean fallbackFeatureSystemPropertyEnabled) {
        PublishMessageConfiguration publishMessageConfiguration = new PublishMessageConfiguration(false, AbstractCourierRestClient.MAX_RETRIES);
        if (!fallbackFeatureSystemPropertyEnabled) {
            return publishMessageConfiguration;
        }
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED) && destination.getPrimaryRegionDown()) {
            if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                LOGGER.info(String.format("Primary region was detected as down earlier, trying to publish to the primary region to check if it is back up. Destination name: %s", destination.getName()));
                publishMessageConfiguration.setRetryCount(0);
            } else {
                publishMessageConfiguration.setUseFallbackDestination(true);
            }
        }
        return publishMessageConfiguration;
    }

    public static void updateFallbackStateOnPublishSuccess(Destination destination, boolean publishExecutedOnFallbackDestination) {
        if (!publishExecutedOnFallbackDestination) {
            if (destination.getPrimaryRegionDown()) {
                LOGGER.warn(String.format("Primary region is available again, switching to primary region for future publish calls. Destination name: %s", destination.getName()));
            }
            destination.setPrimaryRegionDown(false);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
        }
    }

    public static PublishMessageErrorResult determinePublishNextStepsOnError(String msg, Throwable e, Destination destination, boolean publishExecutedOnFallbackDestination) {
        PublishMessageErrorResult publishMessageErrorResult = new PublishMessageErrorResult(false, msg);
        int statusCode = FallbackUtils.getStatusCode(e);
        if (publishExecutedOnFallbackDestination) {
            if (e instanceof ResourceNotFoundException) {
                destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                publishMessageErrorResult.setMsg(String.format("Failed to publish message to destination '%s' as primary region is unavailable and fallback destination is not configured: %s", destination.getName(), e.getMessage()));
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
                if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
                    publishMessageErrorResult.setMakeCallToFallback(true);
                }
            }
        }
        return publishMessageErrorResult;
    }

    public static ReceiveMessageConfiguration determineReceiveMessageConfiguration(Destination destination, int primaryRegionStatusCheckIntervalMs, int fallbackMessagesCheckIntervalMs, boolean fallbackFeatureSystemPropertyEnabled) {
        ReceiveMessageConfiguration receiveMessageConfiguration = new ReceiveMessageConfiguration(false, false, AbstractCourierRestClient.MAX_RETRIES);
        if (!fallbackFeatureSystemPropertyEnabled) {
            return receiveMessageConfiguration;
        }
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
            String logMsgConsumeFromFallback = "Consuming messages from fallback destination: " + destination.getName(true);
            String logMsgConsumeFromPrimary = "Consuming messages from primary destination: " + destination.getName(false);
            long fallbackMessagesLastChecked = destination.getFallbackMessagesLastChecked();
            if (TIME_SUPPLIER.get() - fallbackMessagesLastChecked >= (long)fallbackMessagesCheckIntervalMs) {
                LOGGER.info(logMsgConsumeFromFallback + " to check if it has any messages");
                receiveMessageConfiguration.setUseFallbackDestination(true);
                receiveMessageConfiguration.setShortPolling(true);
                receiveMessageConfiguration.setRetryCount(0);
                return receiveMessageConfiguration;
            }
            if (destination.getFallbackHasMessages()) {
                LOGGER.info(logMsgConsumeFromFallback);
                receiveMessageConfiguration.setUseFallbackDestination(true);
                return receiveMessageConfiguration;
            }
            if (destination.getPrimaryRegionDown() && !FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                LOGGER.info(logMsgConsumeFromFallback);
                receiveMessageConfiguration.setUseFallbackDestination(true);
                return receiveMessageConfiguration;
            }
            receiveMessageConfiguration.setUseFallbackDestination(false);
            if (destination.getPrimaryRegionDown()) {
                receiveMessageConfiguration.setRetryCount(0);
                LOGGER.info(logMsgConsumeFromPrimary + " to check if it is back up");
            } else {
                LOGGER.info(logMsgConsumeFromPrimary);
            }
        }
        return receiveMessageConfiguration;
    }

    public static ReceiveMessageResult determineReceiveNextStepsOnSuccess(List<AnypointMQMessage> messages, Destination destination, boolean receiveExecutedOnFallbackDestination, int primaryRegionStatusCheckIntervalMs) {
        ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(false, AbstractCourierRestClient.MAX_RETRIES);
        if (receiveExecutedOnFallbackDestination) {
            destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            if (messages != null && !messages.isEmpty()) {
                destination.setFallbackHasMessages(true);
                return receiveMessageResult;
            }
            destination.setFallbackHasMessages(false);
            if (!destination.getPrimaryRegionDown()) {
                LOGGER.info("No messages received from fallback destination, consuming from primary destination: " + destination.getName(false));
                receiveMessageResult.setMakeCallToPrimary(true);
                return receiveMessageResult;
            }
            if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                LOGGER.info("Primary region was detected as down earlier, trying to consume from primary destination: " + destination.getName(false) + " to check if it is back up");
                receiveMessageResult.setMakeCallToPrimary(true);
                receiveMessageResult.setRetryCount(0);
            } else {
                destination.setFallbackHasMessages(true);
            }
        } else {
            if (destination.getPrimaryRegionDown()) {
                destination.setFallbackMessagesLastChecked(0L);
            }
            destination.setPrimaryRegionDown(false);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
        }
        return receiveMessageResult;
    }

    public static ReceiveMessageResult determineReceiveNextStepsOnError(Throwable e, Destination destination, boolean receiveExecutedOnFallbackDestination, int primaryRegionStatusCheckIntervalMs) {
        ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(false, AbstractCourierRestClient.MAX_RETRIES);
        if (receiveExecutedOnFallbackDestination) {
            destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            destination.setFallbackHasMessages(false);
            if (!destination.getPrimaryRegionDown()) {
                LOGGER.info("Consuming messages from primary destination: " + destination.getName(false));
                receiveMessageResult.setMakeCallToPrimary(true);
                return receiveMessageResult;
            }
            if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                LOGGER.info("Primary region was detected as down earlier, trying to consume from primary destination: " + destination.getName(false) + " to check if it is back up");
                receiveMessageResult.setMakeCallToPrimary(true);
                receiveMessageResult.setRetryCount(0);
            } else {
                destination.setFallbackHasMessages(true);
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            int statusCode = FallbackUtils.getStatusCode(e);
            if (statusCode >= 400 && statusCode < 500) {
                if (destination.getPrimaryRegionDown()) {
                    destination.setFallbackMessagesLastChecked(0L);
                }
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
                destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
                destination.setFallbackHasMessages(true);
            }
        }
        return receiveMessageResult;
    }

    public static AckNackFallbackConfiguration getAckNackFallbackConfiguration(String destination) {
        AckNackFallbackConfiguration ackNackFallbackConfig = new AckNackFallbackConfiguration(false, destination);
        if (destination.endsWith(FALLBACK_SUFFIX)) {
            ackNackFallbackConfig.setUseFallbackDestination(true);
            ackNackFallbackConfig.setDestination(destination.substring(0, destination.length() - FALLBACK_SUFFIX.length()));
        }
        return ackNackFallbackConfig;
    }

    public static void updateFallbackStateOnAckNackError(Throwable e, Destination destination, boolean executedOnFallbackDestination) {
        if (!executedOnFallbackDestination) {
            int statusCode = FallbackUtils.getStatusCode(e);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
            }
        }
    }
}

