/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.mulesoft.mq.restclient.client.Request;
import com.mulesoft.mq.restclient.client.RequestBuilder;
import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;

public class DefaultCourierRestClient
extends AbstractCourierRestClient {
    private final AsyncHttpClient asyncHttpClient;
    private final int defaultTimeout = 22000;

    public DefaultCourierRestClient(AsyncHttpClient asyncHttpClient, String courierApiUrl, OAuthCredentials oAuthCredentials, String userAgentInfo) {
        this(asyncHttpClient, courierApiUrl, null, oAuthCredentials, userAgentInfo);
    }

    public DefaultCourierRestClient(AsyncHttpClient asyncHttpClient, String courierApiUrl, String fallbackCourierApiUrl, OAuthCredentials oAuthCredentials, String userAgentInfo) {
        super(courierApiUrl, fallbackCourierApiUrl, oAuthCredentials, userAgentInfo);
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.asyncHttpClient.close();
    }

    @Override
    protected RequestBuilder newRequestBuilder() {
        return new RequestBuilder(){
            private com.ning.http.client.RequestBuilder requestBuilder = (com.ning.http.client.RequestBuilder)new com.ning.http.client.RequestBuilder().setRequestTimeout(22000);

            @Override
            public RequestBuilder wrap(Request request) {
                if (request instanceof RequestBasedRequest) {
                    this.requestBuilder = ((RequestBasedRequest)request).requestBuilder;
                }
                return this;
            }

            @Override
            public RequestBuilder use(RequestBuilder.Method method) {
                this.requestBuilder.setMethod(method.toString());
                return this;
            }

            @Override
            public RequestBuilder to(String url) {
                this.requestBuilder.setUrl(url);
                return this;
            }

            @Override
            public RequestBuilder withBody(String body) {
                this.requestBuilder.setBody(body);
                return this;
            }

            @Override
            public RequestBuilder withHeader(String name, String value) {
                this.requestBuilder.addHeader(name, value);
                return this;
            }

            @Override
            public RequestBuilder withFormParam(String name, String value) {
                this.requestBuilder.addFormParam(name, value);
                return this;
            }

            @Override
            public RequestBuilder withQueryParam(String name, String value) {
                this.requestBuilder.addQueryParam(name, value);
                return this;
            }

            @Override
            public RequestBuilder waitingUpTo(long duration, TimeUnit unit) {
                this.requestBuilder.setRequestTimeout((int)unit.toMillis(duration));
                return this;
            }

            @Override
            public Request build() {
                return new RequestBasedRequest(this.requestBuilder);
            }
        };
    }

    private Observable<Response> doProcess(final RequestBasedRequest request) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Response>(){

            public void call(final Subscriber<? super Response> subscriber) {
                subscriber.onStart();
                DefaultCourierRestClient.this.asyncHttpClient.executeRequest(request.request, (AsyncHandler)new AsyncCompletionHandler<Void>(){

                    public Void onCompleted(com.ning.http.client.Response response) throws Exception {
                        Response mqResponse = DefaultCourierRestClient.convert(response);
                        DefaultCourierRestClient.this.logProcessSuccess(request, mqResponse);
                        try {
                            subscriber.onNext((Object)mqResponse);
                        }
                        finally {
                            subscriber.onCompleted();
                        }
                        return null;
                    }

                    public void onThrowable(Throwable t) {
                        DefaultCourierRestClient.this.logProcessError(request, t);
                        subscriber.onError(t);
                    }
                });
            }
        });
    }

    private static Response convert(final com.ning.http.client.Response response) {
        return new Response(){

            @Override
            public String getBody() {
                try {
                    return response.getResponseBody();
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public boolean isOk() {
                return response.getStatusCode() >= 200 && response.getStatusCode() < 300;
            }

            @Override
            public String getStatusText() {
                return response.getStatusText();
            }

            @Override
            public int getStatusCode() {
                return response.getStatusCode();
            }

            @Override
            public String getHeader(String name) {
                return response.getHeader(name);
            }

            @Override
            public boolean isUnauthorized() {
                return response.getStatusCode() == 401;
            }
        };
    }

    @Override
    protected Observable<Response> process(Request request) {
        this.logProcessStart(request);
        return this.doProcess((RequestBasedRequest)request);
    }

    class RequestBasedRequest
    implements Request {
        private final com.ning.http.client.Request request;
        private com.ning.http.client.RequestBuilder requestBuilder;

        RequestBasedRequest(com.ning.http.client.RequestBuilder requestBuilder) {
            this.requestBuilder = requestBuilder;
            this.request = requestBuilder.build();
        }

        @Override
        public RequestBuilder.Method getMethod() {
            return RequestBuilder.Method.valueOf(this.request.getMethod());
        }

        @Override
        public String getUrl() {
            return this.request.getUrl();
        }
    }
}

