/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.impl;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.CourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.impl.LockedMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDestination
implements Destination {
    private final CourierRestClient client;
    private final DestinationLocation destinationLocation;
    private Destination.FallbackConfiguration fallbackConfiguration = Destination.FallbackConfiguration.UNKNOWN;
    private Boolean primaryRegionDown = false;
    private Long primaryRegionStatusLastChecked;
    private Boolean fallbackHasMessages;
    private Long fallbackMessagesLastChecked;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDestination.class);

    @Override
    public Long getFallbackMessagesLastChecked() {
        return this.fallbackMessagesLastChecked;
    }

    public DefaultDestination(CourierRestClient client, DestinationLocation destinationLocation) {
        this.client = client;
        this.destinationLocation = destinationLocation;
    }

    @Override
    public String getName() {
        return this.destinationLocation.getName();
    }

    @Override
    public String getName(boolean getFallbackName) {
        if (getFallbackName) {
            return this.destinationLocation.getFallbackName();
        }
        return this.getName();
    }

    @Override
    public Destination.FallbackConfiguration getFallbackConfiguration() {
        return this.fallbackConfiguration;
    }

    @Override
    public void setFallbackConfiguration(Destination.FallbackConfiguration fallbackConfiguration) {
        this.fallbackConfiguration = fallbackConfiguration;
    }

    @Override
    public Boolean getPrimaryRegionDown() {
        return this.primaryRegionDown;
    }

    @Override
    public void setPrimaryRegionDown(Boolean primaryRegionDown) {
        this.primaryRegionDown = primaryRegionDown;
    }

    @Override
    public Long getPrimaryRegionStatusLastChecked() {
        return this.primaryRegionStatusLastChecked;
    }

    @Override
    public void setPrimaryRegionStatusLastChecked(Long primaryRegionStatusLastChecked) {
        this.primaryRegionStatusLastChecked = primaryRegionStatusLastChecked;
    }

    @Override
    public Boolean getFallbackHasMessages() {
        return this.fallbackHasMessages;
    }

    @Override
    public void setFallbackHasMessages(Boolean fallbackHasMessages) {
        this.fallbackHasMessages = fallbackHasMessages;
    }

    @Override
    public void setFallbackMessagesLastChecked(Long fallbackMessagesLastChecked) {
        this.fallbackMessagesLastChecked = fallbackMessagesLastChecked;
    }

    public DefaultCourierObservable<FallbackConfigResult> fetchFallbackConfiguration(boolean useFallbackDestination) {
        return new DefaultCourierObservable<FallbackConfigResult>(this.client.getFallbackConfig(this.destinationLocation, useFallbackDestination));
    }

    @Override
    public CourierObservable<MessageIdResult> send(AnypointMQMessage message) {
        return this.send(message, (Boolean)false, (Integer)AbstractCourierRestClient.MAX_RETRIES);
    }

    public DefaultCourierObservable<MessageIdResult> send(AnypointMQMessage message, Boolean useFallbackDestination, Integer retryCount) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.send(this.destinationLocation, message, useFallbackDestination, retryCount));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages) {
        return this.send((List)messages, (Boolean)false, (Integer)AbstractCourierRestClient.MAX_RETRIES);
    }

    public DefaultCourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages, Boolean useFallbackDestination, Integer retryCount) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.send(this.destinationLocation, messages, useFallbackDestination, retryCount));
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive() {
        return this.receive(1, 0L, 120000L, false);
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl, Boolean useFallbackDestination) {
        return new DefaultCourierObservable<List<AnypointMQMessage>>(this.client.receive(this.destinationLocation, batchSize, pollingTime, lockTtl, useFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> ack(List<Lock> locks) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.ack(this.destinationLocation, locks));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> ack(List<Lock> locks, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.ack(this.destinationLocation, locks, usedFallbackDestination));
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.ack(this.destinationLocation, lock));
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.ack(this.destinationLocation, lock, usedFallbackDestination));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> nack(List<Lock> locks) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.nack(this.destinationLocation, locks));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> nack(List<Lock> locks, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.nack(this.destinationLocation, locks, usedFallbackDestination));
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.nack(this.destinationLocation, lock));
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.nack(this.destinationLocation, lock, usedFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (AnypointMQMessage message : messages) {
            newTtls.add(new NewTtl(message.getMessageId(), message.getLockId(), lockInterval));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval, boolean usedFallbackDestination) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (AnypointMQMessage message : messages) {
            newTtls.add(new NewTtl(message.getMessageId(), message.getLockId(), lockInterval));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls, usedFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (LockedMessage lockedMessage : lockedMessages) {
            newTtls.add(new NewTtl(lockedMessage.getMessage().getMessageId(), lockedMessage.getMessage().getLockId(), lockedMessage.getLockInterval()));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls));
    }

    @Override
    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages, boolean usedFallbackDestination) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (LockedMessage lockedMessage : lockedMessages) {
            newTtls.add(new NewTtl(lockedMessage.getMessage().getMessageId(), lockedMessage.getMessage().getLockId(), lockedMessage.getLockInterval()));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls, usedFallbackDestination));
    }

    @Override
    public AnypointMQMessageBuilder newMessageBuilder() {
        return new AnypointMQMessageBuilder();
    }

    public void printAllFallbackStateVariables(Destination destination) {
        LOGGER.debug("Destination object: " + destination.toString());
        LOGGER.debug("Destination name: " + this.getName(false));
        LOGGER.debug("Fallback destination name: " + this.getName(true));
        LOGGER.debug("Fallback configuration: " + this.getFallbackConfiguration().toString());
        LOGGER.debug("Primary region down?: " + this.getPrimaryRegionDown());
        if (this.getPrimaryRegionStatusLastChecked() == null) {
            LOGGER.debug("Primary region status last checked " + null);
        } else {
            LOGGER.debug("Primary region status last checked " + (System.currentTimeMillis() - this.getPrimaryRegionStatusLastChecked()) + " milliseconds ago");
        }
        LOGGER.debug("Fallback has messages?: " + this.getFallbackHasMessages());
        if (this.getFallbackMessagesLastChecked() == null) {
            LOGGER.debug("Fallback messages last checked " + null);
        } else {
            LOGGER.debug("Fallback messages last checked " + (System.currentTimeMillis() - this.getFallbackMessagesLastChecked()) + " milliseconds ago");
        }
    }
}

