/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageErrorResult;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageResult;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.impl.TimeSupplier;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FallbackUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackUtils.class);
    public static final String FALLBACK_SUFFIX = "_fb";
    private static final TimeSupplier TIME_SUPPLIER = new TimeSupplier();
    private static final Random RANDOM = new Random();
    private static final double JITTER_PERCENTAGE = 0.1;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;

    private FallbackUtils() {
    }

    private static double getJitteredValueOfPrimaryRegionStatusCheckInterval(int primaryRegionStatusCheckIntervalMs) {
        double jitter = (double)primaryRegionStatusCheckIntervalMs * 0.1 * (RANDOM.nextDouble() * 2.0 - 1.0);
        return (double)primaryRegionStatusCheckIntervalMs + jitter;
    }

    private static boolean shouldTryPrimaryRegion(long primaryRegionStatusLastChecked, Integer primaryRegionStatusCheckIntervalMs) {
        return (double)(TIME_SUPPLIER.get() - primaryRegionStatusLastChecked) >= FallbackUtils.getJitteredValueOfPrimaryRegionStatusCheckInterval(primaryRegionStatusCheckIntervalMs);
    }

    protected static void fetchFallbackConfigurationFromBackend(final Destination destination, final boolean useFallbackDestination) {
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.UNKNOWN)) {
            LOGGER.debug(String.format("Fetching information on whether the destination '%s' has fallback destination configured", destination));
            destination.fetchFallbackConfiguration(useFallbackDestination, 0).subscribe(new CourierObserver<FallbackConfigResult>(){

                @Override
                public void onSuccess(FallbackConfigResult fallbackConfigResult) {
                    if (fallbackConfigResult.getIsFallbackEnabled() != null && fallbackConfigResult.getIsFallbackEnabled().booleanValue()) {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.CONFIGURED);
                        LOGGER.info("Fallback destination is configured for the destination: " + destination.getName());
                    } else {
                        destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                        LOGGER.info("Fallback destination is not configured for the destination: " + destination.getName());
                    }
                }

                @Override
                public void onError(Throwable e) {
                    LOGGER.debug(String.format("Error while trying to fetch fallback configuration for destination '%s': %s", destination.getName(), e.getMessage()));
                    int statusCode = FallbackUtils.getStatusCode(e);
                    if (statusCode >= 400 && statusCode < 500) {
                        if (statusCode != 401 && statusCode != 429) {
                            destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                            if (statusCode == 403) {
                                LOGGER.debug("Unable to fetch information about fallback configuration: Client id doesn't have permissions, possibly because user didn't configure 'Publish' or 'Consume' scope");
                            } else {
                                LOGGER.info("Fallback destination is not configured for the destination: " + destination.getName());
                            }
                        }
                    } else if (!useFallbackDestination) {
                        LOGGER.debug("Fetching fallback configuration from fallback region");
                        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, true);
                    }
                }
            });
        }
    }

    private static int getStatusCode(Throwable e) {
        int statusCode = 0;
        try {
            if (e instanceof RestException) {
                statusCode = ((RestException)e).getResponse().get().getStatusCode();
            }
        }
        catch (Exception e1) {
            LOGGER.debug("Unable to retrieve error code: " + e1.getMessage() + " from the API error: " + e.getMessage());
        }
        return statusCode;
    }

    public static PublishMessageConfiguration determinePublishMessageConfiguration(Destination destination, int primaryRegionStatusCheckIntervalMs, boolean fallbackEnabled) {
        PublishMessageConfiguration publishMessageConfiguration = new PublishMessageConfiguration(false, AbstractCourierRestClient.MAX_RETRIES);
        if (!fallbackEnabled) {
            return publishMessageConfiguration;
        }
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED) && destination.getPrimaryRegionDown()) {
            if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                LOGGER.debug("Primary region was detected as down earlier, trying to publish to check if it is back up");
                publishMessageConfiguration.setRetryCount(0);
            } else {
                publishMessageConfiguration.setUseFallbackDestination(true);
            }
        }
        return publishMessageConfiguration;
    }

    public static void updateFallbackStateOnPublishSuccess(Destination destination, boolean useFallbackDestination) {
        if (!useFallbackDestination) {
            if (destination.getPrimaryRegionDown()) {
                LOGGER.warn("Primary region is available again, switching to primary region for future publish calls");
            }
            destination.setPrimaryRegionDown(false);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
        }
    }

    public static PublishMessageErrorResult updateFallbackStateOnPublishError(String msg, Throwable e, Destination destination, boolean useFallbackDestination) {
        PublishMessageErrorResult publishMessageErrorResult = new PublishMessageErrorResult(false, msg);
        int statusCode = FallbackUtils.getStatusCode(e);
        if (useFallbackDestination) {
            if (e instanceof ResourceNotFoundException) {
                destination.setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
                publishMessageErrorResult.setMsg(String.format("Failed to publish message to destination '%s' as primary region is unavailable and fallback destination is not configured: %s", destination.getName(), e.getMessage()));
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
                if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
                    publishMessageErrorResult.setMakeCallToFallback(true);
                }
            }
        }
        return publishMessageErrorResult;
    }

    public static ReceiveMessageConfiguration determineReceiveMessageConfiguration(Destination destination, int primaryRegionStatusCheckIntervalMs, int fallbackMessagesCheckIntervalMs, boolean fallbackEnabled) {
        ReceiveMessageConfiguration receiveMessageConfiguration = new ReceiveMessageConfiguration(false, false, AbstractCourierRestClient.MAX_RETRIES);
        if (!fallbackEnabled) {
            return receiveMessageConfiguration;
        }
        FallbackUtils.fetchFallbackConfigurationFromBackend(destination, false);
        if (destination.getFallbackConfiguration().equals((Object)Destination.FallbackConfiguration.CONFIGURED)) {
            long fallbackMessagesLastChecked = destination.getFallbackMessagesLastChecked();
            if (TIME_SUPPLIER.get() - fallbackMessagesLastChecked < (long)fallbackMessagesCheckIntervalMs) {
                if (destination.getFallbackHasMessages() || destination.getPrimaryRegionDown() && !FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                    receiveMessageConfiguration.setUseFallbackDestination(true);
                } else {
                    receiveMessageConfiguration.setUseFallbackDestination(false);
                    if (destination.getPrimaryRegionDown()) {
                        receiveMessageConfiguration.setRetryCount(0);
                    }
                }
            } else {
                receiveMessageConfiguration.setUseFallbackDestination(true);
                receiveMessageConfiguration.setShortPolling(true);
                receiveMessageConfiguration.setRetryCount(0);
            }
            LOGGER.info("Consuming messages from " + (receiveMessageConfiguration.getUseFallbackDestination() ? "fallback" : "primary") + " destination: " + destination.getName(receiveMessageConfiguration.getUseFallbackDestination()));
        }
        return receiveMessageConfiguration;
    }

    public static ReceiveMessageResult updateFallbackStateOnReceiveSuccess(List<AnypointMQMessage> messages, Destination destination, boolean useFallbackDestination, int primaryRegionStatusCheckIntervalMs) {
        ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(false, AbstractCourierRestClient.MAX_RETRIES);
        if (useFallbackDestination) {
            destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            if (messages != null && !messages.isEmpty()) {
                destination.setFallbackHasMessages(true);
            } else {
                destination.setFallbackHasMessages(false);
                if (destination.getPrimaryRegionDown()) {
                    if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                        receiveMessageResult.setMakeCallToPrimary(true);
                        receiveMessageResult.setRetryCount(0);
                    } else {
                        destination.setFallbackHasMessages(true);
                    }
                } else {
                    receiveMessageResult.setMakeCallToPrimary(true);
                }
            }
        } else {
            if (destination.getPrimaryRegionDown()) {
                destination.setFallbackMessagesLastChecked(0L);
            }
            destination.setPrimaryRegionDown(false);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
        }
        return receiveMessageResult;
    }

    public static ReceiveMessageResult updateFallbackStateOnReceiveError(Throwable e, Destination destination, boolean useFallbackDestination, int primaryRegionStatusCheckIntervalMs) {
        ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(false, AbstractCourierRestClient.MAX_RETRIES);
        int statusCode = FallbackUtils.getStatusCode(e);
        if (useFallbackDestination) {
            destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
            destination.setFallbackHasMessages(false);
            if (destination.getPrimaryRegionDown()) {
                if (FallbackUtils.shouldTryPrimaryRegion(destination.getPrimaryRegionStatusLastChecked(), primaryRegionStatusCheckIntervalMs)) {
                    receiveMessageResult.setMakeCallToPrimary(true);
                    receiveMessageResult.setRetryCount(0);
                } else {
                    destination.setFallbackHasMessages(true);
                }
            } else {
                receiveMessageResult.setMakeCallToPrimary(true);
            }
        } else {
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                if (destination.getPrimaryRegionDown()) {
                    destination.setFallbackMessagesLastChecked(0L);
                }
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
                destination.setFallbackMessagesLastChecked(TIME_SUPPLIER.get());
                destination.setFallbackHasMessages(true);
            }
        }
        return receiveMessageResult;
    }

    public static void updateFallbackStateOnAckNackError(Throwable e, Destination destination, boolean useFallbackDestination) {
        if (!useFallbackDestination) {
            int statusCode = FallbackUtils.getStatusCode(e);
            destination.setPrimaryRegionStatusLastChecked(TIME_SUPPLIER.get());
            if (statusCode >= 400 && statusCode < 500) {
                destination.setPrimaryRegionDown(false);
            } else {
                destination.setPrimaryRegionDown(true);
            }
        }
    }
}

