/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.utils.AnypointMQFallbackRegionMapping;
import com.mulesoft.mq.restclient.utils.AnypointMQServiceRegistryUrls;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public class UrlConversionUtils {
    private static final String BASE_URL_DELIMITER = ".";
    private static final String BASE_URL_DELIMITER_ESCAPED = "\\.";

    private static String getbackupHostFromPrimaryHost(String primaryHost, boolean isServiceRegistry) {
        AnypointMQFallbackRegionMapping.DeploymentEnvironment deploymentEnvironment;
        ArrayList<String> hostSplitByDelimiter = new ArrayList<String>(Arrays.asList(primaryHost.split(BASE_URL_DELIMITER_ESCAPED)));
        try {
            deploymentEnvironment = AnypointMQFallbackRegionMapping.DeploymentEnvironment.valueOf((String)hostSplitByDelimiter.get(1));
        }
        catch (IllegalArgumentException e) {
            deploymentEnvironment = AnypointMQFallbackRegionMapping.DeploymentEnvironment.prod;
        }
        String primaryRegionMappingKey = (String)hostSplitByDelimiter.get(0);
        String backupRegionMappingKey = isServiceRegistry ? AnypointMQServiceRegistryUrls.getBackupRegionForPrimary(deploymentEnvironment, primaryRegionMappingKey) : AnypointMQFallbackRegionMapping.getFallbackRegionFromPrimary(deploymentEnvironment, primaryRegionMappingKey);
        if (backupRegionMappingKey == null) {
            return null;
        }
        hostSplitByDelimiter.set(0, backupRegionMappingKey);
        return String.join((CharSequence)BASE_URL_DELIMITER, hostSplitByDelimiter);
    }

    public static String getBackupRegionUrl(String primaryRegionUrl, boolean isServiceRegistry) {
        try {
            URL primaryUrl = new URI(primaryRegionUrl).toURL();
            String backupHost = UrlConversionUtils.getbackupHostFromPrimaryHost(primaryUrl.getHost(), isServiceRegistry);
            if (backupHost == null) {
                return null;
            }
            URL backupUrl = new URL(primaryUrl.getProtocol(), backupHost, primaryUrl.getPort(), primaryUrl.getFile());
            return backupUrl.toString();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            return null;
        }
    }

    public static enum RegionType {
        SERVICE_REGISTRY_BACKUP_REGION,
        FALLBACK_REGION;

    }
}

