/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.utils.AnypointMQFallbackRegionMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnypointMQServiceRegistryUrls {
    private static final Map<AnypointMQFallbackRegionMapping.DeploymentEnvironment, List<String>> SERVICE_REGISTRY_BACKUP_REGIONS = new HashMap<AnypointMQFallbackRegionMapping.DeploymentEnvironment, List<String>>();

    public static String getBackupRegionForPrimary(AnypointMQFallbackRegionMapping.DeploymentEnvironment deploymentEnvironment, String primaryRegion) {
        List<String> backupRegions = SERVICE_REGISTRY_BACKUP_REGIONS.get((Object)deploymentEnvironment);
        if (backupRegions.get(0).equals(primaryRegion)) {
            return backupRegions.size() == 1 ? null : backupRegions.get(1);
        }
        return backupRegions.get(0);
    }

    static {
        List<String> backupRegionsDevx = Arrays.asList("mq-us-east-1", "mq-eu-west-1");
        List<String> backupRegionsQax = Arrays.asList("mq-us-east-1", "mq-eu-west-1");
        List<String> backupRegionsStgx = Arrays.asList("mq-us-west-2", "mq-ap-southeast-2");
        List<String> backupRegionsProd = Arrays.asList("mq-us-west-2", "mq-ap-southeast-2");
        List<String> backupRegionsProdEu = Arrays.asList("mq-eu-west-1", "mq-eu-central-1");
        List<String> backupRegionsGstg = Collections.singletonList("mq-us-gov-west-1");
        List<String> backupRegionsGprod = Collections.singletonList("mq-us-gov-west-1");
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.devx, backupRegionsDevx);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.qax, backupRegionsQax);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.stgx, backupRegionsStgx);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.prod, backupRegionsProd);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.eu1, backupRegionsProdEu);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.gstg, backupRegionsGstg);
        SERVICE_REGISTRY_BACKUP_REGIONS.put(AnypointMQFallbackRegionMapping.DeploymentEnvironment.gov, backupRegionsGprod);
    }
}

