/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.PublishMessageErrorResult;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageConfiguration;
import com.mulesoft.mq.restclient.client.mq.domain.ReceiveMessageResult;
import com.mulesoft.mq.restclient.exception.ResourceNotFoundException;
import com.mulesoft.mq.restclient.exception.RestException;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.utils.FallbackUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FallbackUtilsTestCase {
    @Mock
    Destination destinationMock;
    private static final String DESTINATION_NAME = "testDestination";

    @Before
    public void setup() {
        Mockito.when((Object)this.destinationMock.getName()).thenReturn((Object)DESTINATION_NAME);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldNotCallBackendWhenValueAlreadyPopulated() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.NOT_CONFIGURED);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(Matchers.anyBoolean(), Matchers.anyInt());
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldNotGoToFallbackRegionWhenPrimaryWasSuccessful() {
        boolean fallbackEnabledFlagInResponse = false;
        CourierObservable onSuccessCourierObservable = this.mockFallbackConfigResult(fallbackEnabledFlagInResponse);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onSuccessCourierObservable);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).fetchFallbackConfiguration(false, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(true, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldSetNotConfiguredFor400ErrorFromPrimary() {
        CourierObservable onFailureCourierObservable = this.mockFallbackConfigResponseError(400);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onFailureCourierObservable);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).fetchFallbackConfiguration(false, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(true, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldSetNotConfiguredFor403ErrorFromPrimary() {
        CourierObservable onFailureCourierObservable = this.mockFallbackConfigResponseError(403);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onFailureCourierObservable);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).fetchFallbackConfiguration(false, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(true, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldNotGoToFallbackFor401ErrorFromPrimary() {
        CourierObservable onFailureCourierObservable = this.mockFallbackConfigResponseError(401);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onFailureCourierObservable);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).fetchFallbackConfiguration(false, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(true, 0);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldNotGoToFallbackFor429ErrorFromPrimary() {
        CourierObservable onFailureCourierObservable = this.mockFallbackConfigResponseError(429);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onFailureCourierObservable);
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).fetchFallbackConfiguration(false, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).fetchFallbackConfiguration(true, 0);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldGoToFallbackWhenPrimaryRegionAPIFailsWithUnknownError() {
        CourierObservable onFailureCourierObservable = this.mockFallbackConfigResponseError(0);
        CourierObservable onSuccessCourierObservable = this.mockFallbackConfigResult(true);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)onFailureCourierObservable);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(true, 0)).thenReturn((Object)onSuccessCourierObservable);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.destinationMock});
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)inOrder.verify((Object)this.destinationMock)).fetchFallbackConfiguration(false, 0);
        ((Destination)inOrder.verify((Object)this.destinationMock)).fetchFallbackConfiguration(true, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackConfiguration(Destination.FallbackConfiguration.CONFIGURED);
    }

    @Test
    public void fetchFallbackConfigurationFromBackendShouldGoToFallbackWhenPrimaryRegionAPIFailsWith5xx() {
        CourierObservable primaryRegionOnFailureCourierObservable = this.mockFallbackConfigResponseError(500);
        CourierObservable fallbackRegionOnFailureCourierObservable = this.mockFallbackConfigResponseError(400);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)primaryRegionOnFailureCourierObservable);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(true, 0)).thenReturn((Object)fallbackRegionOnFailureCourierObservable);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.destinationMock});
        FallbackUtils.fetchFallbackConfigurationFromBackend((Destination)this.destinationMock, (boolean)false);
        ((Destination)inOrder.verify((Object)this.destinationMock)).fetchFallbackConfiguration(false, 0);
        ((Destination)inOrder.verify((Object)this.destinationMock)).fetchFallbackConfiguration(true, 0);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackConfiguration(Destination.FallbackConfiguration.NOT_CONFIGURED);
    }

    @Test
    public void determinePublishMessageConfigurationShouldNotUseFallbackRegionWhenFallbackFeatureNotEnabledViaSystemProperty() {
        boolean fallbackFeatureEnabledSystemProperty = false;
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)1000, (boolean)fallbackFeatureEnabledSystemProperty).getUseFallbackDestination());
    }

    @Test
    public void determinePublishMessageConfigurationShouldNotUseFallbackRegionWhenFallbackConfigurationStatusUnknown() {
        CourierObservable primaryRegionOnFailureCourierObservable = this.mockFallbackConfigResponseError(429);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)primaryRegionOnFailureCourierObservable);
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)1000, (boolean)true).getUseFallbackDestination());
    }

    @Test
    public void determinePublishMessageConfigurationShouldNotUseFallbackRegionWhenFallbackFeatureNotConfiguredForDestination() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.NOT_CONFIGURED);
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)1000, (boolean)true).getUseFallbackDestination());
    }

    @Test
    public void determinePublishMessageConfigurationShouldNotUseFallbackRegionWhenPrimaryRegionIsUp() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)1000, (boolean)true).getUseFallbackDestination());
    }

    @Test
    public void determinePublishMessageConfigurationShouldTryPrimaryRegionWithNoRetriesWhenPrimaryRegionIsDownButWeNeedToCheckPrimaryStatus() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 300000L));
        PublishMessageConfiguration publishConfig = FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)1000, (boolean)true);
        TestCase.assertEquals((boolean)false, (boolean)publishConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)0, (int)publishConfig.getRetryCount());
    }

    @Test
    public void determinePublishMessageConfigurationShouldTryFallbackRegionWithRetriesWhenPrimaryRegionIsDown() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 20000L));
        PublishMessageConfiguration publishConfig = FallbackUtils.determinePublishMessageConfiguration((Destination)this.destinationMock, (int)60000, (boolean)true);
        TestCase.assertEquals((boolean)true, (boolean)publishConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)5, (int)publishConfig.getRetryCount());
    }

    @Test
    public void determinePublishNextStepsOnErrorForFallbackDestination() {
        String errMsg = "custom error message";
        PublishMessageErrorResult errorResult = FallbackUtils.determinePublishNextStepsOnError((String)errMsg, (Throwable)this.getMockedRestException(500), (Destination)this.destinationMock, (boolean)true);
        TestCase.assertEquals((String)errMsg, (String)errorResult.getMsg());
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToFallback());
    }

    @Test
    public void determinePublishNextStepsOnErrorHTTP404ForFallbackDestination() {
        String errMsg = "custom error message";
        PublishMessageErrorResult errorResult = FallbackUtils.determinePublishNextStepsOnError((String)errMsg, (Throwable)new ResourceNotFoundException("404", null, null), (Destination)this.destinationMock, (boolean)true);
        Assert.assertTrue((boolean)errorResult.getMsg().contains("fallback destination is not configured"));
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToFallback());
    }

    @Test
    public void determinePublishNextStepsOnErrorHTTP4xxForPrimaryDestination() {
        PublishMessageErrorResult errorResult = FallbackUtils.determinePublishNextStepsOnError((String)"", (Throwable)this.getMockedRestException(409), (Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToFallback());
    }

    @Test
    public void determinePublishNextStepsOnErrorHTTP5xxForPrimaryDestination() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        PublishMessageErrorResult errorResult = FallbackUtils.determinePublishNextStepsOnError((String)"", (Throwable)this.getMockedRestException(501), (Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        TestCase.assertEquals((boolean)true, (boolean)errorResult.getMakeCallToFallback());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldNotUseFallbackRegionWhenFallbackFeatureNotEnabledViaSystemProperty() {
        boolean fallbackFeatureEnabledSystemProperty = false;
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)1000, (int)1000, (boolean)fallbackFeatureEnabledSystemProperty).getUseFallbackDestination());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldNotUseFallbackRegionWhenFallbackConfigurationStatusUnknown() {
        CourierObservable primaryRegionOnFailureCourierObservable = this.mockFallbackConfigResponseError(429);
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.UNKNOWN);
        Mockito.when((Object)this.destinationMock.fetchFallbackConfiguration(false, 0)).thenReturn((Object)primaryRegionOnFailureCourierObservable);
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)1000, (int)1000, (boolean)true).getUseFallbackDestination());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldNotUseFallbackRegionWhenFallbackFeatureNotConfiguredForDestination() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.NOT_CONFIGURED);
        TestCase.assertEquals((boolean)false, (boolean)FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)1000, (int)1000, (boolean)true).getUseFallbackDestination());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldUseFallbackRegionWhenLastCheckedTimeExceedsConfiguration() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        int fallbackMessagesCheckInterval = 300000;
        Mockito.when((Object)this.destinationMock.getFallbackMessagesLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 360000L));
        ReceiveMessageConfiguration receiveConfig = FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)1000, (int)fallbackMessagesCheckInterval, (boolean)true);
        TestCase.assertEquals((boolean)true, (boolean)receiveConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)0, (int)receiveConfig.getRetryCount());
        TestCase.assertEquals((boolean)true, (boolean)receiveConfig.getShortPolling());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldUseFallbackRegionWhenFallbackHasMessages() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getFallbackHasMessages()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getFallbackMessagesLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 60000L));
        int fallbackMessagesCheckInterval = 300000;
        ReceiveMessageConfiguration receiveConfig = FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)1000, (int)fallbackMessagesCheckInterval, (boolean)true);
        TestCase.assertEquals((boolean)true, (boolean)receiveConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)5, (int)receiveConfig.getRetryCount());
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getShortPolling());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldUseFallbackRegionWhenPrimaryIsDownAndFallbackHasNoMessages() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getFallbackHasMessages()).thenReturn((Object)false);
        Mockito.when((Object)this.destinationMock.getFallbackMessagesLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 60000L));
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 30000L));
        int fallbackMessagesCheckInterval = 300000;
        int primaryStatusCheckInterval = 60000;
        ReceiveMessageConfiguration receiveConfig = FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)primaryStatusCheckInterval, (int)fallbackMessagesCheckInterval, (boolean)true);
        TestCase.assertEquals((boolean)true, (boolean)receiveConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)5, (int)receiveConfig.getRetryCount());
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getShortPolling());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldUsePrimaryRegionWhenPrimaryIsDownButWeNeedToCheckPrimaryStatus() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getFallbackHasMessages()).thenReturn((Object)false);
        Mockito.when((Object)this.destinationMock.getFallbackMessagesLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 60000L));
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 180000L));
        int fallbackMessagesCheckInterval = 300000;
        int primaryStatusCheckInterval = 60000;
        ReceiveMessageConfiguration receiveConfig = FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)primaryStatusCheckInterval, (int)fallbackMessagesCheckInterval, (boolean)true);
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)0, (int)receiveConfig.getRetryCount());
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getShortPolling());
    }

    @Test
    public void determineReceiveMessageConfigurationShouldUsePrimaryRegionWhenFallbackHasNoMessagesAndPrimaryRegionIsUp() {
        Mockito.when((Object)this.destinationMock.getFallbackConfiguration()).thenReturn((Object)Destination.FallbackConfiguration.CONFIGURED);
        Mockito.when((Object)this.destinationMock.getFallbackHasMessages()).thenReturn((Object)false);
        Mockito.when((Object)this.destinationMock.getFallbackMessagesLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 60000L));
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        int fallbackMessagesCheckInterval = 300000;
        int primaryStatusCheckInterval = 60000;
        ReceiveMessageConfiguration receiveConfig = FallbackUtils.determineReceiveMessageConfiguration((Destination)this.destinationMock, (int)primaryStatusCheckInterval, (int)fallbackMessagesCheckInterval, (boolean)true);
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getUseFallbackDestination());
        TestCase.assertEquals((int)5, (int)receiveConfig.getRetryCount());
        TestCase.assertEquals((boolean)false, (boolean)receiveConfig.getShortPolling());
    }

    @Test
    public void determineReceiveNextStepsOnSuccessHTTP200ForFallbackDestination() {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(Mockito.mock(AnypointMQMessage.class));
        ReceiveMessageResult successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)true, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)successResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnSuccessHTTP204ForFallbackDestinationAndPrimaryRegionUp() {
        ArrayList messages = new ArrayList();
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        ReceiveMessageResult successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)true, (int)1000);
        TestCase.assertEquals((boolean)true, (boolean)successResult.getMakeCallToPrimary());
        TestCase.assertEquals((int)5, (int)successResult.getRetryCount());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnSuccessHTTP204ForFallbackDestinationAndPrimaryRegionDown() {
        ArrayList messages = new ArrayList();
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 1000L));
        int primaryRegionStatusCheckInterval = 60000;
        ReceiveMessageResult successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)true, (int)primaryRegionStatusCheckInterval);
        TestCase.assertEquals((boolean)false, (boolean)successResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnSuccessHTTP204ForFallbackDestinationAndPrimaryRegionDownButShouldCheckPrimary() {
        ArrayList messages = new ArrayList();
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 300000L));
        int primaryRegionStatusCheckInterval = 60000;
        ReceiveMessageResult successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)true, (int)primaryRegionStatusCheckInterval);
        TestCase.assertEquals((boolean)true, (boolean)successResult.getMakeCallToPrimary());
        TestCase.assertEquals((int)0, (int)successResult.getRetryCount());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnSuccessHTTP2xxForPrimaryDestination() {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(Mockito.mock(AnypointMQMessage.class));
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        ReceiveMessageResult successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)false, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)successResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        Mockito.reset((Object[])new Destination[]{this.destinationMock});
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        successResult = FallbackUtils.determineReceiveNextStepsOnSuccess(messages, (Destination)this.destinationMock, (boolean)false, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)successResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).setFallbackHasMessages(Matchers.anyBoolean());
    }

    @Test
    public void determineReceiveNextStepsOnErrorForFallbackDestinationAndPrimaryRegionUp() {
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        ReceiveMessageResult errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(501), (Destination)this.destinationMock, (boolean)true, (int)1000);
        TestCase.assertEquals((boolean)true, (boolean)errorResult.getMakeCallToPrimary());
        TestCase.assertEquals((int)5, (int)errorResult.getRetryCount());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnErrorForFallbackDestinationAndPrimaryRegionDown() {
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 10000L));
        int primaryRegionStatusCheckInterval = 60000;
        ReceiveMessageResult errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(400), (Destination)this.destinationMock, (boolean)true, (int)primaryRegionStatusCheckInterval);
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnErrorForFallbackDestinationAndPrimaryRegionDownButShouldCheckPrimary() {
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        Mockito.when((Object)this.destinationMock.getPrimaryRegionStatusLastChecked()).thenReturn((Object)(System.currentTimeMillis() - 300000L));
        int primaryRegionStatusCheckInterval = 60000;
        ReceiveMessageResult errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(400), (Destination)this.destinationMock, (boolean)true, (int)primaryRegionStatusCheckInterval);
        TestCase.assertEquals((boolean)true, (boolean)errorResult.getMakeCallToPrimary());
        TestCase.assertEquals((int)0, (int)errorResult.getRetryCount());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void determineReceiveNextStepsOnErrorHTTP4xxForPrimaryDestination() {
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)false);
        ReceiveMessageResult errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(400), (Destination)this.destinationMock, (boolean)false, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).setFallbackHasMessages(Matchers.anyBoolean());
        Mockito.reset((Object[])new Destination[]{this.destinationMock});
        Mockito.when((Object)this.destinationMock.getPrimaryRegionDown()).thenReturn((Object)true);
        errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(400), (Destination)this.destinationMock, (boolean)false, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(0L);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).setFallbackHasMessages(Matchers.anyBoolean());
    }

    @Test
    public void determineReceiveNextStepsOnErrorUnknownErrorForPrimaryDestination() {
        ReceiveMessageResult errorResult = FallbackUtils.determineReceiveNextStepsOnError((Throwable)this.getMockedRestException(500), (Destination)this.destinationMock, (boolean)false, (int)1000);
        TestCase.assertEquals((boolean)false, (boolean)errorResult.getMakeCallToPrimary());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackHasMessages(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setFallbackMessagesLastChecked(Matchers.anyLong());
    }

    @Test
    public void updateFallbackStateOnAckNackErrorForFallbackDestination() {
        FallbackUtils.updateFallbackStateOnAckNackError((Throwable)this.getMockedRestException(500), (Destination)this.destinationMock, (boolean)true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.never())).setPrimaryRegionDown(Matchers.anyBoolean());
    }

    @Test
    public void updateFallbackStateOnAckNackErrorHTTP4xxForPrimaryDestination() {
        FallbackUtils.updateFallbackStateOnAckNackError((Throwable)this.getMockedRestException(404), (Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
    }

    @Test
    public void updateFallbackStateOnAckNackErrorHTTP5xxForPrimaryDestination() {
        FallbackUtils.updateFallbackStateOnAckNackError((Throwable)this.getMockedRestException(500), (Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
    }

    @Test
    public void updateFallbackStateOnAckNackErrorUnknownErrorForPrimaryDestination() {
        FallbackUtils.updateFallbackStateOnAckNackError((Throwable)new TimeoutException(), (Destination)this.destinationMock, (boolean)false);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionDown(true);
        ((Destination)Mockito.verify((Object)this.destinationMock, (VerificationMode)Mockito.times((int)1))).setPrimaryRegionStatusLastChecked(Matchers.anyLong());
    }

    private CourierObservable mockSubscribe(Answer answer) {
        CourierObservable onErrorCourierObservable = (CourierObservable)Mockito.mock(CourierObservable.class);
        ((CourierObservable)Mockito.doAnswer((Answer)answer).when((Object)onErrorCourierObservable)).subscribe((CourierObserver)Matchers.any());
        return onErrorCourierObservable;
    }

    private CourierObservable mockFallbackConfigResult(Boolean fallbackEnabled) {
        FallbackConfigResult result = (FallbackConfigResult)Mockito.mock(FallbackConfigResult.class);
        Mockito.when((Object)result.getIsFallbackEnabled()).thenReturn((Object)fallbackEnabled);
        return this.mockSubscribe(invocation -> {
            ((CourierObserver)invocation.getArguments()[0]).onSuccess((Object)result);
            return null;
        });
    }

    private CourierObservable mockFallbackConfigResponseError(int statusCode) {
        RestException exception = this.getMockedRestException(statusCode);
        CourierObservable onErrorCourierObservable = this.mockSubscribe(invocation -> {
            ((CourierObserver)invocation.getArguments()[0]).onError((Throwable)exception);
            return null;
        });
        return onErrorCourierObservable;
    }

    private RestException getMockedRestException(int statusCode) {
        RestException exception = (RestException)Mockito.mock(RestException.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)exception.getResponse()).thenReturn(Optional.of(response));
        return exception;
    }
}

